/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.auth.ext;

import java.util.Calendar;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.auth.AuthenticationResponse;
import org.ldaptive.auth.AuthenticationResponseHandler;
import org.ldaptive.auth.ext.EDirectoryAccountState;
import org.ldaptive.io.GeneralizedTimeValueTranscoder;

public class EDirectoryAuthenticationResponseHandler
implements AuthenticationResponseHandler {
    private int warningHours;

    public EDirectoryAuthenticationResponseHandler() {
    }

    public EDirectoryAuthenticationResponseHandler(int hours) {
        if (hours <= 0) {
            throw new IllegalArgumentException("Hours must be > 0");
        }
        this.warningHours = hours;
    }

    @Override
    public void handle(AuthenticationResponse response) {
        if (response.getMessage() != null) {
            EDirectoryAccountState.Error edError = EDirectoryAccountState.Error.parse(response.getMessage());
            if (edError != null) {
                response.setAccountState(new EDirectoryAccountState(edError));
            }
        } else if (((Boolean)response.getResult()).booleanValue()) {
            int loginRemainingValue;
            LdapEntry entry = response.getLdapEntry();
            LdapAttribute expTime = entry.getAttribute("passwordExpirationTime");
            LdapAttribute loginRemaining = entry.getAttribute("loginGraceRemaining");
            int n = loginRemainingValue = loginRemaining != null ? Integer.parseInt(loginRemaining.getStringValue()) : 0;
            if (expTime != null) {
                Calendar exp = expTime.getValue(new GeneralizedTimeValueTranscoder());
                if (this.warningHours > 0) {
                    Calendar now = Calendar.getInstance();
                    Calendar warn = (Calendar)exp.clone();
                    warn.add(11, -this.warningHours);
                    if (now.after(warn)) {
                        response.setAccountState(new EDirectoryAccountState(exp, loginRemainingValue));
                    }
                } else {
                    response.setAccountState(new EDirectoryAccountState(exp, loginRemainingValue));
                }
            } else if (loginRemaining != null) {
                response.setAccountState(new EDirectoryAccountState(null, loginRemainingValue));
            }
        }
    }
}

