/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.control;

import java.nio.ByteBuffer;
import org.ldaptive.LdapUtils;
import org.ldaptive.asn1.AbstractParseHandler;
import org.ldaptive.asn1.DERParser;
import org.ldaptive.asn1.DERPath;
import org.ldaptive.asn1.IntegerType;
import org.ldaptive.asn1.OctetStringType;
import org.ldaptive.asn1.ParseHandler;
import org.ldaptive.control.AbstractControl;
import org.ldaptive.control.PersistentSearchChangeType;
import org.ldaptive.control.ResponseControl;

public class EntryChangeNotificationControl
extends AbstractControl
implements ResponseControl {
    public static final String OID = "2.16.840.1.113730.3.4.7";
    private static final int HASH_CODE_SEED = 773;
    private PersistentSearchChangeType changeType;
    private String previousDn;
    private long changeNumber = -1L;

    public EntryChangeNotificationControl() {
        super(OID);
    }

    public EntryChangeNotificationControl(boolean critical) {
        super(OID, critical);
    }

    public EntryChangeNotificationControl(PersistentSearchChangeType type) {
        this(type, false);
    }

    public EntryChangeNotificationControl(PersistentSearchChangeType type, boolean critical) {
        super(OID, critical);
        this.setChangeType(type);
    }

    public EntryChangeNotificationControl(PersistentSearchChangeType type, String dn, long number) {
        this(type, dn, number, false);
    }

    public EntryChangeNotificationControl(PersistentSearchChangeType type, String dn, long number, boolean critical) {
        super(OID, critical);
        this.setChangeType(type);
        this.setPreviousDn(dn);
        this.setChangeNumber(number);
    }

    public PersistentSearchChangeType getChangeType() {
        return this.changeType;
    }

    public void setChangeType(PersistentSearchChangeType type) {
        this.changeType = type;
    }

    public String getPreviousDn() {
        return this.previousDn;
    }

    public void setPreviousDn(String dn) {
        this.previousDn = dn;
    }

    public long getChangeNumber() {
        return this.changeNumber;
    }

    public void setChangeNumber(long number) {
        this.changeNumber = number;
    }

    @Override
    public int hashCode() {
        return LdapUtils.computeHashCode(773, new Object[]{this.getOID(), this.getCriticality(), this.changeType, this.previousDn, this.changeNumber});
    }

    public String toString() {
        return String.format("[%s@%d::criticality=%s, changeType=%s, previousDn=%s, changeNumber=%s]", new Object[]{this.getClass().getName(), this.hashCode(), this.getCriticality(), this.changeType, this.previousDn, this.changeNumber});
    }

    @Override
    public void decode(byte[] berValue) {
        this.logger.trace("decoding control: {}", (Object)LdapUtils.base64Encode(berValue));
        DERParser parser = new DERParser();
        parser.registerHandler(ChangeTypeHandler.PATH, (ParseHandler)new ChangeTypeHandler(this));
        parser.registerHandler(PreviousDnHandler.PATH, (ParseHandler)new PreviousDnHandler(this));
        parser.registerHandler(ChangeNumberHandler.PATH, (ParseHandler)new ChangeNumberHandler(this));
        parser.parse(ByteBuffer.wrap(berValue));
    }

    private static class ChangeNumberHandler
    extends AbstractParseHandler<EntryChangeNotificationControl> {
        public static final DERPath PATH = new DERPath("/SEQ/INT[2]");

        public ChangeNumberHandler(EntryChangeNotificationControl control) {
            super(control);
        }

        @Override
        public void handle(DERParser parser, ByteBuffer encoded) {
            ((EntryChangeNotificationControl)this.getObject()).setChangeNumber(IntegerType.decode(encoded).intValue());
        }
    }

    private static class PreviousDnHandler
    extends AbstractParseHandler<EntryChangeNotificationControl> {
        public static final DERPath PATH = new DERPath("/SEQ/OCTSTR[1]");

        public PreviousDnHandler(EntryChangeNotificationControl control) {
            super(control);
        }

        @Override
        public void handle(DERParser parser, ByteBuffer encoded) {
            ((EntryChangeNotificationControl)this.getObject()).setPreviousDn(OctetStringType.decode(encoded));
        }
    }

    private static class ChangeTypeHandler
    extends AbstractParseHandler<EntryChangeNotificationControl> {
        public static final DERPath PATH = new DERPath("/SEQ/ENUM");

        public ChangeTypeHandler(EntryChangeNotificationControl control) {
            super(control);
        }

        @Override
        public void handle(DERParser parser, ByteBuffer encoded) {
            int typeValue = IntegerType.decode(encoded).intValue();
            PersistentSearchChangeType ct = PersistentSearchChangeType.valueOf(typeValue);
            if (ct == null) {
                throw new IllegalArgumentException("Unknown change type code " + typeValue);
            }
            ((EntryChangeNotificationControl)this.getObject()).setChangeType(ct);
        }
    }
}

