/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.control;

import java.nio.ByteBuffer;
import org.ldaptive.LdapUtils;
import org.ldaptive.ResultCode;
import org.ldaptive.asn1.AbstractParseHandler;
import org.ldaptive.asn1.DERParser;
import org.ldaptive.asn1.DERPath;
import org.ldaptive.asn1.IntegerType;
import org.ldaptive.asn1.OctetStringType;
import org.ldaptive.asn1.ParseHandler;
import org.ldaptive.control.AbstractControl;
import org.ldaptive.control.ResponseControl;

public class SortResponseControl
extends AbstractControl
implements ResponseControl {
    public static final String OID = "1.2.840.113556.1.4.474";
    private static final int HASH_CODE_SEED = 733;
    private ResultCode sortResult;
    private String attributeName;

    public SortResponseControl() {
        super(OID);
    }

    public SortResponseControl(boolean critical) {
        super(OID, critical);
    }

    public SortResponseControl(ResultCode code, boolean critical) {
        super(OID, critical);
        this.setSortResult(code);
    }

    public SortResponseControl(ResultCode code, String attrName, boolean critical) {
        super(OID, critical);
        this.setSortResult(code);
        this.setAttributeName(attrName);
    }

    public ResultCode getSortResult() {
        return this.sortResult;
    }

    public void setSortResult(ResultCode code) {
        this.sortResult = code;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String name) {
        this.attributeName = name;
    }

    @Override
    public int hashCode() {
        return LdapUtils.computeHashCode(733, new Object[]{this.getOID(), this.getCriticality(), this.sortResult, this.attributeName});
    }

    public String toString() {
        return String.format("[%s@%d::criticality=%s, sortResult=%s, attributeName=%s]", new Object[]{this.getClass().getName(), this.hashCode(), this.getCriticality(), this.sortResult, this.attributeName});
    }

    @Override
    public void decode(byte[] berValue) {
        this.logger.trace("decoding control: {}", (Object)LdapUtils.base64Encode(berValue));
        DERParser parser = new DERParser();
        parser.registerHandler(SortResultHandler.PATH, (ParseHandler)new SortResultHandler(this));
        parser.registerHandler(AttributeTypeHandler.PATH, (ParseHandler)new AttributeTypeHandler(this));
        parser.parse(ByteBuffer.wrap(berValue));
    }

    private static class AttributeTypeHandler
    extends AbstractParseHandler<SortResponseControl> {
        public static final DERPath PATH = new DERPath("/SEQ/CTX(1)");

        public AttributeTypeHandler(SortResponseControl control) {
            super(control);
        }

        @Override
        public void handle(DERParser parser, ByteBuffer encoded) {
            ((SortResponseControl)this.getObject()).setAttributeName(OctetStringType.decode(encoded));
        }
    }

    private static class SortResultHandler
    extends AbstractParseHandler<SortResponseControl> {
        public static final DERPath PATH = new DERPath("/SEQ/ENUM");

        public SortResultHandler(SortResponseControl control) {
            super(control);
        }

        @Override
        public void handle(DERParser parser, ByteBuffer encoded) {
            int resultValue = IntegerType.decode(encoded).intValue();
            ResultCode rc = ResultCode.valueOf(resultValue);
            if (rc == null) {
                throw new IllegalArgumentException("Unknown result code " + resultValue);
            }
            ((SortResponseControl)this.getObject()).setSortResult(rc);
        }
    }
}

