/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.pool;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.ldaptive.Connection;
import org.ldaptive.DefaultConnectionFactory;
import org.ldaptive.LdapException;
import org.ldaptive.LdapUtils;
import org.ldaptive.Response;
import org.ldaptive.pool.AbstractPool;
import org.ldaptive.pool.ActivationException;
import org.ldaptive.pool.ConnectionPool;
import org.ldaptive.pool.IdlePruneStrategy;
import org.ldaptive.pool.PoolException;
import org.ldaptive.pool.PooledConnectionProxy;
import org.ldaptive.pool.PooledConnectionStatistics;
import org.ldaptive.pool.Queue;
import org.ldaptive.pool.QueueType;
import org.ldaptive.pool.ValidationException;

public abstract class AbstractConnectionPool
extends AbstractPool<Connection>
implements ConnectionPool {
    protected final ReentrantLock poolLock = new ReentrantLock();
    protected final Condition poolNotEmpty = this.poolLock.newCondition();
    protected final ReentrantLock checkInLock = new ReentrantLock();
    protected final ReentrantLock checkOutLock = new ReentrantLock();
    protected Queue<PooledConnectionProxy> available;
    protected Queue<PooledConnectionProxy> active;
    private DefaultConnectionFactory connectionFactory;
    private boolean connectOnCreate = true;
    private QueueType queueType = QueueType.LIFO;
    private ScheduledExecutorService poolExecutor;
    private boolean initialized;
    private boolean failFastInitialize = true;

    public DefaultConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(DefaultConnectionFactory cf) {
        this.logger.trace("setting connectionFactory: {}", (Object)cf);
        this.connectionFactory = cf;
    }

    public boolean getConnectOnCreate() {
        return this.connectOnCreate;
    }

    public void setConnectOnCreate(boolean b) {
        this.logger.trace("setting connectOnCreate: {}", (Object)b);
        this.connectOnCreate = b;
    }

    public QueueType getQueueType() {
        return this.queueType;
    }

    public void setQueueType(QueueType type) {
        this.logger.trace("setting queueType: {}", (Object)type);
        this.queueType = type;
    }

    public boolean getFailFastInitialize() {
        return this.failFastInitialize;
    }

    public void setFailFastInitialize(boolean b) {
        this.logger.trace("setting failFastInitialize: {}", (Object)b);
        this.failFastInitialize = b;
    }

    protected void isInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Pool has not been initialized");
        }
    }

    @Override
    public void initialize() {
        if (this.initialized) {
            throw new IllegalStateException("Pool has already been initialized");
        }
        this.logger.debug("beginning pool initialization for {}", (Object)this);
        if ((this.getPoolConfig().isValidatePeriodically() || this.getPoolConfig().isValidateOnCheckIn() || this.getPoolConfig().isValidateOnCheckOut()) && this.getValidator() == null) {
            throw new IllegalStateException("Validation is enabled, but no validator has been configured");
        }
        if (!(this.getPoolConfig().isValidatePeriodically() || this.getPoolConfig().isValidateOnCheckIn() || this.getPoolConfig().isValidateOnCheckOut() || this.getValidator() == null)) {
            throw new IllegalStateException("Validator configured, but no validate flag has been set");
        }
        this.getPoolConfig().makeImmutable();
        if (this.getPruneStrategy() == null) {
            this.setPruneStrategy(new IdlePruneStrategy());
            this.logger.debug("no prune strategy configured, using default prune strategy: {}", (Object)this.getPruneStrategy());
        }
        this.available = new Queue(this.queueType);
        this.active = new Queue(this.queueType);
        IllegalStateException growException = null;
        try {
            this.grow(this.getPoolConfig().getMinPoolSize(), true);
        }
        catch (IllegalStateException e) {
            growException = e;
        }
        if (this.available.isEmpty() && this.getPoolConfig().getMinPoolSize() > 0) {
            if (this.failFastInitialize) {
                throw new IllegalStateException("Could not initialize pool size", growException != null ? growException.getCause() : null);
            }
            this.logger.warn("Could not initialize pool size, pool is empty");
        }
        this.logger.debug("initialized available queue: {}", this.available);
        this.poolExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                return t;
            }
        });
        this.poolExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                AbstractConnectionPool.this.logger.debug("begin prune task for {}", (Object)AbstractConnectionPool.this);
                try {
                    AbstractConnectionPool.this.prune();
                }
                catch (Exception e) {
                    AbstractConnectionPool.this.logger.error("prune task failed for {}", (Object)AbstractConnectionPool.this);
                }
                AbstractConnectionPool.this.logger.debug("end prune task for {}", (Object)AbstractConnectionPool.this);
            }
        }, this.getPruneStrategy().getPrunePeriod(), this.getPruneStrategy().getPrunePeriod(), TimeUnit.SECONDS);
        this.logger.debug("prune pool task scheduled for {}", (Object)this);
        this.poolExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                AbstractConnectionPool.this.logger.debug("begin validate task for {}", (Object)AbstractConnectionPool.this);
                try {
                    AbstractConnectionPool.this.validate();
                }
                catch (Exception e) {
                    AbstractConnectionPool.this.logger.error("validation task failed for {}", (Object)AbstractConnectionPool.this);
                }
                AbstractConnectionPool.this.logger.debug("end validate task for {}", (Object)AbstractConnectionPool.this);
            }
        }, this.getPoolConfig().getValidatePeriod(), this.getPoolConfig().getValidatePeriod(), TimeUnit.SECONDS);
        this.logger.debug("validate pool task scheduled for {}", (Object)this);
        this.initialized = true;
        this.logger.info("pool initialized {}", (Object)this);
    }

    protected void grow(int size) {
        this.grow(size, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void grow(int size, boolean throwOnFailure) {
        this.logger.trace("waiting for pool lock to initialize pool {}", (Object)this.poolLock.getQueueLength());
        this.poolLock.lock();
        try {
            IllegalStateException lastThrown = null;
            int currentPoolSize = this.active.size() + this.available.size();
            this.logger.debug("checking connection pool size >= {} for {}", (Object)size, (Object)this);
            for (int count = 0; currentPoolSize < size && count < size * 2; ++count) {
                try {
                    PooledConnectionProxy pc = this.createAvailableConnection(throwOnFailure);
                    if (pc != null && this.getPoolConfig().isValidateOnCheckIn()) {
                        if (this.validate(pc.getConnection())) {
                            this.logger.trace("connection passed initialize validation: {}", (Object)pc);
                        } else {
                            this.logger.warn("connection failed initialize validation: {}", (Object)pc);
                            this.removeAvailableConnection(pc);
                        }
                    }
                }
                catch (IllegalStateException e) {
                    lastThrown = e;
                }
                currentPoolSize = this.active.size() + this.available.size();
            }
            if (lastThrown != null && currentPoolSize < size) {
                throw lastThrown;
            }
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.isInitialized();
        this.logger.debug("closing connection pool of size {} for {}", (Object)(this.available.size() + this.active.size()), (Object)this);
        this.poolLock.lock();
        try {
            PooledConnectionProxy pc;
            while (!this.available.isEmpty()) {
                pc = this.available.remove();
                pc.getConnection().close();
                this.logger.trace("destroyed connection: {}", (Object)pc);
            }
            while (!this.active.isEmpty()) {
                pc = this.active.remove();
                pc.getConnection().close();
                this.logger.trace("destroyed connection: {}", (Object)pc);
            }
            this.logger.debug("pool closed");
        }
        finally {
            this.poolLock.unlock();
        }
        this.logger.debug("shutting down executor");
        this.poolExecutor.shutdown();
        this.logger.debug("executor shutdown");
        this.logger.info("pool closed {}", (Object)this);
        this.initialized = false;
    }

    @Override
    public abstract Connection getConnection() throws PoolException;

    public abstract void putConnection(Connection var1);

    protected PooledConnectionProxy createConnection() {
        return this.createConnection(false);
    }

    protected PooledConnectionProxy createConnection(boolean throwOnFailure) {
        Response<Void> r;
        Connection c;
        block4: {
            c = this.connectionFactory.getConnection();
            r = null;
            if (this.connectOnCreate) {
                try {
                    r = c.open();
                }
                catch (LdapException e) {
                    this.logger.error("{} unable to connect to the ldap", (Object)this, (Object)e);
                    c = null;
                    if (!throwOnFailure) break block4;
                    throw new IllegalStateException("unable to connect to the ldap", e);
                }
            }
        }
        if (c != null) {
            return new DefaultPooledConnectionProxy(c, r);
        }
        return null;
    }

    protected PooledConnectionProxy createAvailableConnection() {
        return this.createAvailableConnection(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PooledConnectionProxy createAvailableConnection(boolean throwOnFailure) {
        PooledConnectionProxy pc = this.createConnection(throwOnFailure);
        if (pc != null) {
            this.poolLock.lock();
            try {
                this.available.add(pc);
                pc.getPooledConnectionStatistics().addAvailableStat();
                this.logger.info("added available connection: {}", (Object)pc);
            }
            finally {
                this.poolLock.unlock();
            }
        } else {
            this.logger.warn("unable to create available connection");
        }
        return pc;
    }

    protected PooledConnectionProxy createActiveConnection() {
        return this.createActiveConnection(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PooledConnectionProxy createActiveConnection(boolean throwOnFailure) {
        PooledConnectionProxy pc = this.createConnection(throwOnFailure);
        if (pc != null) {
            this.poolLock.lock();
            try {
                this.active.add(pc);
                pc.getPooledConnectionStatistics().addActiveStat();
                this.logger.info("added active connection: {}", (Object)pc);
            }
            finally {
                this.poolLock.unlock();
            }
        } else {
            this.logger.warn("unable to create active connection");
        }
        return pc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAvailableConnection(PooledConnectionProxy pc) {
        boolean destroy = false;
        this.poolLock.lock();
        try {
            if (this.available.remove(pc)) {
                destroy = true;
            } else {
                this.logger.warn("attempt to remove unknown available connection: {}", (Object)pc);
            }
        }
        finally {
            this.poolLock.unlock();
        }
        if (destroy) {
            pc.getConnection().close();
            this.logger.info("destroyed connection: {}", (Object)pc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeActiveConnection(PooledConnectionProxy pc) {
        boolean destroy = false;
        this.poolLock.lock();
        try {
            if (this.active.remove(pc)) {
                destroy = true;
            } else {
                this.logger.warn("attempt to remove unknown active connection: {}", (Object)pc);
            }
        }
        finally {
            this.poolLock.unlock();
        }
        if (destroy) {
            pc.getConnection().close();
            this.logger.info("destroyed connection: {}", (Object)pc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAvailableAndActiveConnection(PooledConnectionProxy pc) {
        boolean destroy = false;
        this.poolLock.lock();
        try {
            if (this.available.remove(pc)) {
                destroy = true;
            } else {
                this.logger.debug("attempt to remove unknown available connection: {}", (Object)pc);
            }
            if (this.active.remove(pc)) {
                destroy = true;
            } else {
                this.logger.debug("attempt to remove unknown active connection: {}", (Object)pc);
            }
        }
        finally {
            this.poolLock.unlock();
        }
        if (destroy) {
            pc.getConnection().close();
            this.logger.info("destroyed connection: {}", (Object)pc);
        }
    }

    protected void activateAndValidateConnection(PooledConnectionProxy pc) throws PoolException {
        if (!this.activate(pc.getConnection())) {
            this.logger.warn("connection failed activation: {}", (Object)pc);
            this.removeAvailableAndActiveConnection(pc);
            throw new ActivationException("Activation of connection failed");
        }
        if (this.getPoolConfig().isValidateOnCheckOut() && !this.validate(pc.getConnection())) {
            this.logger.warn("connection failed check out validation: {}", (Object)pc);
            this.removeAvailableAndActiveConnection(pc);
            throw new ValidationException("Validation of connection failed");
        }
    }

    protected boolean validateAndPassivateConnection(PooledConnectionProxy pc) {
        if (!pc.getConnection().isOpen()) {
            this.logger.debug("connection not open: {}", (Object)pc);
            return false;
        }
        boolean valid = false;
        if (this.getPoolConfig().isValidateOnCheckIn()) {
            if (!this.validate(pc.getConnection())) {
                this.logger.warn("connection failed check in validation: {}", (Object)pc);
            } else {
                valid = true;
            }
        } else {
            valid = true;
        }
        if (valid && !this.passivate(pc.getConnection())) {
            valid = false;
            this.logger.warn("connection failed passivation: {}", (Object)pc);
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prune() {
        this.isInitialized();
        this.logger.trace("waiting for pool lock to prune {}", (Object)this.poolLock.getQueueLength());
        this.poolLock.lock();
        try {
            if (!this.available.isEmpty()) {
                int minPoolSize = this.getPoolConfig().getMinPoolSize();
                int currentPoolSize = this.active.size() + this.available.size();
                if (currentPoolSize > minPoolSize) {
                    this.logger.debug("pruning available pool of size {} for {}", (Object)this.available.size(), (Object)this);
                    int numConnToPrune = this.available.size();
                    Iterator<PooledConnectionProxy> connIter = this.available.iterator();
                    for (int i = 0; i < numConnToPrune && currentPoolSize > minPoolSize; ++i) {
                        PooledConnectionProxy pc = connIter.next();
                        if (!this.getPruneStrategy().prune(pc)) continue;
                        connIter.remove();
                        pc.getConnection().close();
                        this.logger.trace("destroyed connection: {}", (Object)pc);
                        --currentPoolSize;
                    }
                    if (numConnToPrune == this.available.size()) {
                        this.logger.debug("prune strategy did not remove any connections");
                    } else {
                        this.logger.info("available pool size pruned to {}", (Object)this.available.size());
                    }
                } else {
                    this.logger.debug("pool size is {}, no connections pruned for {}", (Object)currentPoolSize, (Object)this);
                }
            } else {
                this.logger.debug("no available connections, no connections pruned for {}", (Object)this);
            }
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() {
        this.isInitialized();
        this.poolLock.lock();
        try {
            if (!this.available.isEmpty()) {
                if (this.getPoolConfig().isValidatePeriodically()) {
                    this.logger.debug("validate available pool of size {} for {}", (Object)this.available.size(), (Object)this);
                    ArrayList<PooledConnectionProxy> remove = new ArrayList<PooledConnectionProxy>();
                    for (PooledConnectionProxy pc : this.available) {
                        this.logger.trace("validating {}", (Object)pc);
                        if (this.validate(pc.getConnection())) {
                            this.logger.trace("connection passed validation: {}", (Object)pc);
                            continue;
                        }
                        this.logger.warn("connection failed validation: {}", (Object)pc);
                        remove.add(pc);
                    }
                    for (PooledConnectionProxy pc : remove) {
                        this.logger.trace("removing {} from the pool", (Object)pc);
                        this.available.remove(pc);
                        pc.getConnection().close();
                        this.logger.trace("destroyed connection: {}", (Object)pc);
                    }
                }
            } else {
                this.logger.debug("no available connections, no validation performed for {}", (Object)this);
            }
            this.grow(this.getPoolConfig().getMinPoolSize());
            this.logger.debug("pool size after validation is {}", (Object)(this.available.size() + this.active.size()));
        }
        finally {
            this.poolLock.unlock();
        }
    }

    @Override
    public int availableCount() {
        if (this.available == null) {
            return 0;
        }
        return this.available.size();
    }

    @Override
    public int activeCount() {
        if (this.active == null) {
            return 0;
        }
        return this.active.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<PooledConnectionStatistics> getPooledConnectionStatistics() {
        this.isInitialized();
        Set<PooledConnectionStatistics> stats = Collections.unmodifiableSet(new HashSet());
        this.poolLock.lock();
        try {
            for (PooledConnectionProxy cp : this.available) {
                stats.add(cp.getPooledConnectionStatistics());
            }
            for (PooledConnectionProxy cp : this.active) {
                stats.add(cp.getPooledConnectionStatistics());
            }
        }
        finally {
            this.poolLock.unlock();
        }
        return stats;
    }

    protected Connection createConnectionProxy(PooledConnectionProxy pc) {
        return (Connection)Proxy.newProxyInstance(Connection.class.getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)pc);
    }

    protected PooledConnectionProxy retrieveConnectionProxy(Connection proxy) {
        return (PooledConnectionProxy)Proxy.getInvocationHandler(proxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public String toString() {
        return String.format("[%s@%d::name=%s, poolConfig=%s, activator=%s, passivator=%s, validator=%s pruneStrategy=%s, connectOnCreate=%s, connectionFactory=%s, initialized=%s, availableCount=%s, activeCount=%s]", this.getClass().getName(), this.hashCode(), this.getName(), this.getPoolConfig(), this.getActivator(), this.getPassivator(), this.getValidator(), this.getPruneStrategy(), this.connectOnCreate, this.connectionFactory, this.initialized, this.availableCount(), this.activeCount());
    }

    protected class DefaultPooledConnectionProxy
    implements PooledConnectionProxy {
        private static final int HASH_CODE_SEED = 503;
        private final Connection conn;
        private Response<Void> openResponse;
        private final long createdTime = System.currentTimeMillis();
        private final PooledConnectionStatistics statistics = new PooledConnectionStatistics(AbstractConnectionPool.this.getPruneStrategy().getStatisticsSize());

        public DefaultPooledConnectionProxy(Connection c, Response<Void> r) {
            this.conn = c;
            this.openResponse = r;
        }

        @Override
        public ConnectionPool getConnectionPool() {
            return AbstractConnectionPool.this;
        }

        @Override
        public Connection getConnection() {
            return this.conn;
        }

        @Override
        public long getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public PooledConnectionStatistics getPooledConnectionStatistics() {
            return this.statistics;
        }

        public boolean equals(Object o) {
            return LdapUtils.areEqual(this, o);
        }

        public int hashCode() {
            return LdapUtils.computeHashCode(503, this.conn);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Response<Void> retValue = null;
            if ("open".equals(method.getName())) {
                if (!this.conn.isOpen()) {
                    try {
                        this.openResponse = (Response)method.invoke((Object)this.conn, args);
                    }
                    catch (InvocationTargetException e) {
                        throw e.getTargetException();
                    }
                }
                retValue = this.openResponse;
            } else if ("reopen".equals(method.getName())) {
                try {
                    this.openResponse = (Response)method.invoke((Object)this.conn, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
                retValue = this.openResponse;
            } else if ("close".equals(method.getName())) {
                AbstractConnectionPool.this.putConnection((Connection)proxy);
            } else {
                try {
                    retValue = method.invoke((Object)this.conn, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            return retValue;
        }
    }
}

