/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.provider.jndi;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import org.ldaptive.LdapException;
import org.ldaptive.provider.AbstractProviderConnectionFactory;
import org.ldaptive.provider.ConnectionException;
import org.ldaptive.provider.jndi.JndiConnection;
import org.ldaptive.provider.jndi.JndiProviderConfig;
import org.ldaptive.provider.jndi.NamingExceptionUtils;
import org.ldaptive.ssl.SslConfig;
import org.ldaptive.ssl.ThreadLocalTLSSocketFactory;

public class JndiConnectionFactory
extends AbstractProviderConnectionFactory<JndiProviderConfig> {
    private final Map<String, Object> environment;
    private SslConfig threadLocalSslConfig;

    public JndiConnectionFactory(String url, JndiProviderConfig config, Map<String, Object> env) {
        super(url, config);
        this.environment = Collections.unmodifiableMap(env);
        if (ThreadLocalTLSSocketFactory.class.getName().equals(this.environment.get("java.naming.ldap.factory.socket"))) {
            this.threadLocalSslConfig = new ThreadLocalTLSSocketFactory().getSslConfig();
        }
    }

    protected Map<String, Object> getEnvironment() {
        return this.environment;
    }

    @Override
    protected JndiConnection createInternal(String url) throws LdapException {
        JndiConnection conn;
        ThreadLocalTLSSocketFactory sf;
        if (this.threadLocalSslConfig != null && ThreadLocalTLSSocketFactory.class.getName().equals(this.environment.get("java.naming.ldap.factory.socket")) && (sf = new ThreadLocalTLSSocketFactory()).getSslConfig() == null) {
            sf.setSslConfig(this.threadLocalSslConfig);
        }
        Hashtable<String, Object> env = new Hashtable<String, Object>(this.getEnvironment());
        env.put("java.naming.provider.url", url);
        try {
            conn = new JndiConnection(new InitialLdapContext(env, null), (JndiProviderConfig)this.getProviderConfig());
        }
        catch (NamingException e) {
            throw new ConnectionException(e, NamingExceptionUtils.getResultCode(e.getClass()));
        }
        return conn;
    }

    @Override
    public String toString() {
        return String.format("[%s@%d::metadata=%s, environment=%s, providerConfig=%s]", this.getClass().getName(), this.hashCode(), this.getMetadata(), this.environment, this.getProviderConfig());
    }
}

