/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.schema;

import java.text.ParseException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ldaptive.LdapUtils;
import org.ldaptive.schema.AbstractNamedSchemaElement;
import org.ldaptive.schema.AttributeUsage;
import org.ldaptive.schema.Extensions;
import org.ldaptive.schema.SchemaUtils;

public class AttributeType
extends AbstractNamedSchemaElement {
    private static final int HASH_CODE_SEED = 1103;
    private static final Pattern DEFINITION_PATTERN = Pattern.compile("[ ]*\\([ ]*([^ ]+)[ ]*(?:NAME (?:'([^']+)'|\\(([^\\)]+)\\)))?[ ]*(?:DESC '([^']*)')?[ ]*(OBSOLETE)?[ ]*(?:SUP ([^ ]+))?[ ]*(?:EQUALITY ([^ ]+))?[ ]*(?:ORDERING ([^ ]+))?[ ]*(?:SUBSTR ([^ ]+))?[ ]*(?:SYNTAX ([^ ]+))?[ ]*(SINGLE-VALUE)?[ ]*(COLLECTIVE)?[ ]*(NO-USER-MODIFICATION)?[ ]*(?:USAGE (\\p{Alpha}+))?[ ]*(?:(X-[^ ]+.*))?[ ]*\\)[ ]*");
    private final String oid;
    private String superiorType;
    private String equalityMatchingRule;
    private String orderingMatchingRule;
    private String substringMatchingRule;
    private String syntaxOID;
    private boolean singleValued;
    private boolean collective;
    private boolean noUserModification;
    private AttributeUsage usage;

    public AttributeType(String s) {
        this.oid = s;
    }

    public AttributeType(String oid, String[] names, String description, boolean obsolete, String superiorType, String equalityMatchingRule, String orderingMatchingRule, String substringMatchingRule, String syntaxOID, boolean singleValued, boolean collective, boolean noUserModification, AttributeUsage usage, Extensions extensions) {
        this(oid);
        this.setNames(names);
        this.setDescription(description);
        this.setObsolete(obsolete);
        this.setSuperiorType(superiorType);
        this.setEqualityMatchingRule(equalityMatchingRule);
        this.setOrderingMatchingRule(orderingMatchingRule);
        this.setSubstringMatchingRule(substringMatchingRule);
        this.setSyntaxOID(syntaxOID);
        this.setSingleValued(singleValued);
        this.setCollective(collective);
        this.setNoUserModification(noUserModification);
        this.setUsage(usage);
        this.setExtensions(extensions);
    }

    public String getOID() {
        return this.oid;
    }

    public String getSuperiorType() {
        return this.superiorType;
    }

    public void setSuperiorType(String s) {
        this.superiorType = s;
    }

    public String getEqualityMatchingRule() {
        return this.equalityMatchingRule;
    }

    public void setEqualityMatchingRule(String s) {
        this.equalityMatchingRule = s;
    }

    public String getOrderingMatchingRule() {
        return this.orderingMatchingRule;
    }

    public void setOrderingMatchingRule(String s) {
        this.orderingMatchingRule = s;
    }

    public String getSubstringMatchingRule() {
        return this.substringMatchingRule;
    }

    public void setSubstringMatchingRule(String s) {
        this.substringMatchingRule = s;
    }

    public String getSyntaxOID() {
        return this.syntaxOID;
    }

    public String getSyntaxOID(boolean withBoundCount) {
        if (!withBoundCount && this.syntaxOID != null && this.syntaxOID.contains("{") && this.syntaxOID.endsWith("}")) {
            return this.syntaxOID.substring(0, this.syntaxOID.indexOf(123));
        }
        return this.syntaxOID;
    }

    public int getSyntaxOIDBoundCount() {
        if (this.syntaxOID != null && this.syntaxOID.contains("{") && this.syntaxOID.endsWith("}")) {
            String count = this.syntaxOID.substring(this.syntaxOID.indexOf(123) + 1, this.syntaxOID.length() - 1);
            return Integer.parseInt(count);
        }
        return -1;
    }

    public void setSyntaxOID(String s) {
        this.syntaxOID = s;
    }

    public boolean isSingleValued() {
        return this.singleValued;
    }

    public void setSingleValued(boolean b) {
        this.singleValued = b;
    }

    public boolean isCollective() {
        return this.collective;
    }

    public void setCollective(boolean b) {
        this.collective = b;
    }

    public boolean isNoUserModification() {
        return this.noUserModification;
    }

    public void setNoUserModification(boolean b) {
        this.noUserModification = b;
    }

    public AttributeUsage getUsage() {
        return this.usage != null ? this.usage : AttributeUsage.USER_APPLICATIONS;
    }

    public void setUsage(AttributeUsage u) {
        this.usage = u;
    }

    public static AttributeType parse(String definition) throws ParseException {
        Matcher m = DEFINITION_PATTERN.matcher(definition);
        if (!m.matches()) {
            throw new ParseException("Invalid attribute type definition: " + definition, definition.length());
        }
        AttributeType atd = new AttributeType(m.group(1).trim());
        if (m.group(2) != null) {
            atd.setNames(SchemaUtils.parseDescriptors(m.group(2).trim()));
        } else if (m.group(3) != null) {
            atd.setNames(SchemaUtils.parseDescriptors(m.group(3).trim()));
        }
        atd.setDescription(m.group(4) != null ? m.group(4).trim() : null);
        atd.setObsolete(m.group(5) != null);
        atd.setSuperiorType(m.group(6) != null ? m.group(6).trim() : null);
        atd.setEqualityMatchingRule(m.group(7) != null ? m.group(7).trim() : null);
        atd.setOrderingMatchingRule(m.group(8) != null ? m.group(8).trim() : null);
        atd.setSubstringMatchingRule(m.group(9) != null ? m.group(9).trim() : null);
        atd.setSyntaxOID(m.group(10) != null ? m.group(10).trim() : null);
        atd.setSingleValued(m.group(11) != null);
        atd.setCollective(m.group(12) != null);
        atd.setNoUserModification(m.group(13) != null);
        if (m.group(14) != null) {
            atd.setUsage(AttributeUsage.parse(m.group(14).trim()));
        }
        if (m.group(15) != null) {
            atd.setExtensions(Extensions.parse(m.group(15).trim()));
        }
        return atd;
    }

    @Override
    public String format() {
        StringBuilder sb = new StringBuilder("( ");
        sb.append(this.oid).append(" ");
        if (this.getNames() != null && this.getNames().length > 0) {
            sb.append("NAME ");
            sb.append(SchemaUtils.formatDescriptors(this.getNames()));
        }
        if (this.getDescription() != null) {
            sb.append("DESC ");
            sb.append(SchemaUtils.formatDescriptors(this.getDescription()));
        }
        if (this.isObsolete()) {
            sb.append("OBSOLETE ");
        }
        if (this.superiorType != null) {
            sb.append("SUP ").append(this.superiorType).append(" ");
        }
        if (this.equalityMatchingRule != null) {
            sb.append("EQUALITY ").append(this.equalityMatchingRule).append(" ");
        }
        if (this.orderingMatchingRule != null) {
            sb.append("ORDERING ").append(this.orderingMatchingRule).append(" ");
        }
        if (this.substringMatchingRule != null) {
            sb.append("SUBSTR ").append(this.substringMatchingRule).append(" ");
        }
        if (this.syntaxOID != null) {
            sb.append("SYNTAX ").append(this.syntaxOID).append(" ");
        }
        if (this.singleValued) {
            sb.append("SINGLE-VALUE ");
        }
        if (this.collective) {
            sb.append("COLLECTIVE ");
        }
        if (this.noUserModification) {
            sb.append("NO-USER-MODIFICATION ");
        }
        if (this.usage != null) {
            sb.append("USAGE ").append(this.usage.getName()).append(" ");
        }
        if (this.getExtensions() != null) {
            sb.append(this.getExtensions().format());
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public int hashCode() {
        return LdapUtils.computeHashCode(1103, new Object[]{this.oid, this.getNames(), this.getDescription(), this.isObsolete(), this.superiorType, this.equalityMatchingRule, this.orderingMatchingRule, this.substringMatchingRule, this.syntaxOID, this.singleValued, this.collective, this.noUserModification, this.usage, this.getExtensions()});
    }

    public String toString() {
        return String.format("[%s@%d::oid=%s, names=%s, description=%s, obsolete=%s, superiorType=%s, equalityMatchingRule=%s, orderingMatchingRule=%s, substringMatchingRule=%s, syntaxOID=%s, singleValued=%s, collective=%s, noUserModification=%s, usage=%s, extensions=%s]", new Object[]{this.getClass().getName(), this.hashCode(), this.oid, Arrays.toString(this.getNames()), this.getDescription(), this.isObsolete(), this.superiorType, this.equalityMatchingRule, this.orderingMatchingRule, this.substringMatchingRule, this.syntaxOID, this.singleValued, this.collective, this.noUserModification, this.usage, this.getExtensions()});
    }
}

