/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.schema;

import java.text.ParseException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ldaptive.LdapUtils;
import org.ldaptive.schema.AbstractNamedSchemaElement;
import org.ldaptive.schema.Extensions;
import org.ldaptive.schema.SchemaUtils;

public class DITContentRule
extends AbstractNamedSchemaElement {
    private static final int HASH_CODE_SEED = 1151;
    private static final Pattern DEFINITION_PATTERN = Pattern.compile("[ ]*\\([ ]*([^ ]+)[ ]*(?:NAME (?:'([^']+)'|\\(([^\\)]+)\\)))?[ ]*(?:DESC '([^']*)')?[ ]*(OBSOLETE)?[ ]*(?:AUX (?:([^ ]+)|\\(([^\\)]+)\\)))?[ ]*(?:MUST (?:([^ ]+)|\\(([^\\)]+)\\)))?[ ]*(?:MAY (?:([^ ]+)|\\(([^\\)]+)\\)))?[ ]*(?:NOT (?:([^ ]+)|\\(([^\\)]+)\\)))?[ ]*(?:(X-[^ ]+.*))?[ ]*\\)[ ]*");
    private final String oid;
    private String[] auxiliaryClasses;
    private String[] requiredAttributes;
    private String[] optionalAttributes;
    private String[] restrictedAttributes;

    public DITContentRule(String s) {
        this.oid = s;
    }

    public DITContentRule(String oid, String[] names, String description, boolean obsolete, String[] auxiliaryClasses, String[] requiredAttributes, String[] optionalAttributes, String[] restrictedAttributes, Extensions extensions) {
        this(oid);
        this.setNames(names);
        this.setDescription(description);
        this.setObsolete(obsolete);
        this.setAuxiliaryClasses(auxiliaryClasses);
        this.setRequiredAttributes(requiredAttributes);
        this.setOptionalAttributes(optionalAttributes);
        this.setRestrictedAttributes(restrictedAttributes);
        this.setExtensions(extensions);
    }

    public String getOID() {
        return this.oid;
    }

    public String[] getAuxiliaryClasses() {
        return this.auxiliaryClasses;
    }

    public void setAuxiliaryClasses(String[] s) {
        this.auxiliaryClasses = s;
    }

    public String[] getRequiredAttributes() {
        return this.requiredAttributes;
    }

    public void setRequiredAttributes(String[] s) {
        this.requiredAttributes = s;
    }

    public String[] getOptionalAttributes() {
        return this.optionalAttributes;
    }

    public void setOptionalAttributes(String[] s) {
        this.optionalAttributes = s;
    }

    public String[] getRestrictedAttributes() {
        return this.restrictedAttributes;
    }

    public void setRestrictedAttributes(String[] s) {
        this.restrictedAttributes = s;
    }

    public static DITContentRule parse(String definition) throws ParseException {
        Matcher m = DEFINITION_PATTERN.matcher(definition);
        if (!m.matches()) {
            throw new ParseException("Invalid DIT content rule definition: " + definition, definition.length());
        }
        DITContentRule dcrd = new DITContentRule(m.group(1).trim());
        if (m.group(2) != null) {
            dcrd.setNames(SchemaUtils.parseDescriptors(m.group(2).trim()));
        } else if (m.group(3) != null) {
            dcrd.setNames(SchemaUtils.parseDescriptors(m.group(3).trim()));
        }
        dcrd.setDescription(m.group(4) != null ? m.group(4).trim() : null);
        dcrd.setObsolete(m.group(5) != null);
        if (m.group(6) != null) {
            dcrd.setAuxiliaryClasses(SchemaUtils.parseOIDs(m.group(6).trim()));
        } else if (m.group(7) != null) {
            dcrd.setAuxiliaryClasses(SchemaUtils.parseOIDs(m.group(7).trim()));
        }
        if (m.group(9) != null) {
            dcrd.setRequiredAttributes(SchemaUtils.parseOIDs(m.group(9).trim()));
        } else if (m.group(10) != null) {
            dcrd.setRequiredAttributes(SchemaUtils.parseOIDs(m.group(10).trim()));
        }
        if (m.group(11) != null) {
            dcrd.setOptionalAttributes(SchemaUtils.parseOIDs(m.group(11).trim()));
        } else if (m.group(12) != null) {
            dcrd.setOptionalAttributes(SchemaUtils.parseOIDs(m.group(12).trim()));
        }
        if (m.group(11) != null) {
            dcrd.setRestrictedAttributes(SchemaUtils.parseOIDs(m.group(11).trim()));
        } else if (m.group(12) != null) {
            dcrd.setRestrictedAttributes(SchemaUtils.parseOIDs(m.group(12).trim()));
        }
        if (m.group(13) != null) {
            dcrd.setExtensions(Extensions.parse(m.group(13).trim()));
        }
        return dcrd;
    }

    @Override
    public String format() {
        StringBuilder sb = new StringBuilder("( ");
        sb.append(this.oid).append(" ");
        if (this.getNames() != null && this.getNames().length > 0) {
            sb.append("NAME ");
            sb.append(SchemaUtils.formatDescriptors(this.getNames()));
        }
        if (this.getDescription() != null) {
            sb.append("DESC ");
            sb.append(SchemaUtils.formatDescriptors(this.getDescription()));
        }
        if (this.isObsolete()) {
            sb.append("OBSOLETE ");
        }
        if (this.auxiliaryClasses != null && this.auxiliaryClasses.length > 0) {
            sb.append("AUX ");
            sb.append(SchemaUtils.formatOids(this.auxiliaryClasses));
        }
        if (this.requiredAttributes != null && this.requiredAttributes.length > 0) {
            sb.append("MUST ");
            sb.append(SchemaUtils.formatOids(this.requiredAttributes));
        }
        if (this.optionalAttributes != null && this.optionalAttributes.length > 0) {
            sb.append("MAY ");
            sb.append(SchemaUtils.formatOids(this.optionalAttributes));
        }
        if (this.restrictedAttributes != null && this.restrictedAttributes.length > 0) {
            sb.append("NOT ");
            sb.append(SchemaUtils.formatOids(this.restrictedAttributes));
        }
        if (this.getExtensions() != null) {
            sb.append(this.getExtensions().format());
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public int hashCode() {
        return LdapUtils.computeHashCode(1151, this.oid, this.getNames(), this.getDescription(), this.isObsolete(), this.auxiliaryClasses, this.requiredAttributes, this.optionalAttributes, this.restrictedAttributes, this.getExtensions());
    }

    public String toString() {
        return String.format("[%s@%d::oid=%s, names=%s, description=%s, obsolete=%s, auxiliaryClasses=%s, requiredAttributes=%s, optionalAttributes=%s, restrictedAttributes=%s, extensions=%s]", this.getClass().getName(), this.hashCode(), this.oid, Arrays.toString(this.getNames()), this.getDescription(), this.isObsolete(), Arrays.toString(this.auxiliaryClasses), Arrays.toString(this.requiredAttributes), Arrays.toString(this.optionalAttributes), Arrays.toString(this.restrictedAttributes), this.getExtensions());
    }
}

