/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.schema;

import java.text.ParseException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ldaptive.LdapUtils;
import org.ldaptive.schema.AbstractNamedSchemaElement;
import org.ldaptive.schema.Extensions;
import org.ldaptive.schema.SchemaUtils;

public class NameForm
extends AbstractNamedSchemaElement {
    private static final int HASH_CODE_SEED = 1163;
    private static final Pattern DEFINITION_PATTERN = Pattern.compile("[ ]*\\([ ]*([^ ]+)[ ]*(?:NAME (?:'([^']+)'|\\(([^\\)]+)\\)))?[ ]*(?:DESC '([^']*)')?[ ]*(OBSOLETE)?[ ]*(?:OC ([^ ]+))?[ ]*(?:MUST (?:([^ ]+)|\\(([^\\)]+)\\)))?[ ]*(?:MAY (?:([^ ]+)|\\(([^\\)]+)\\)))?[ ]*(?:(X-[^ ]+.*))?[ ]*\\)[ ]*");
    private final String oid;
    private String structuralClass;
    private String[] requiredAttributes;
    private String[] optionalAttributes;

    public NameForm(String s) {
        this.oid = s;
    }

    public NameForm(String oid, String[] names, String description, boolean obsolete, String structuralClass, String[] requiredAttributes, String[] optionalAttributes, Extensions extensions) {
        this(oid);
        this.setNames(names);
        this.setDescription(description);
        this.setObsolete(obsolete);
        this.setStructuralClass(structuralClass);
        this.setRequiredAttributes(requiredAttributes);
        this.setOptionalAttributes(optionalAttributes);
        this.setExtensions(extensions);
    }

    public String getOID() {
        return this.oid;
    }

    public String getStructuralClass() {
        return this.structuralClass;
    }

    public void setStructuralClass(String s) {
        this.structuralClass = s;
    }

    public String[] getRequiredAttributes() {
        return this.requiredAttributes;
    }

    public void setRequiredAttributes(String[] s) {
        this.requiredAttributes = s;
    }

    public String[] getOptionalAttributes() {
        return this.optionalAttributes;
    }

    public void setOptionalAttributes(String[] s) {
        this.optionalAttributes = s;
    }

    public static NameForm parse(String definition) throws ParseException {
        Matcher m = DEFINITION_PATTERN.matcher(definition);
        if (!m.matches()) {
            throw new ParseException("Invalid name form definition: " + definition, definition.length());
        }
        NameForm nfd = new NameForm(m.group(1).trim());
        if (m.group(2) != null) {
            nfd.setNames(SchemaUtils.parseDescriptors(m.group(2).trim()));
        } else if (m.group(3) != null) {
            nfd.setNames(SchemaUtils.parseDescriptors(m.group(3).trim()));
        }
        nfd.setDescription(m.group(4) != null ? m.group(4).trim() : null);
        nfd.setObsolete(m.group(5) != null);
        nfd.setStructuralClass(m.group(6) != null ? m.group(6).trim() : null);
        if (m.group(7) != null) {
            nfd.setRequiredAttributes(SchemaUtils.parseOIDs(m.group(7).trim()));
        } else if (m.group(8) != null) {
            nfd.setRequiredAttributes(SchemaUtils.parseOIDs(m.group(8).trim()));
        }
        if (m.group(9) != null) {
            nfd.setOptionalAttributes(SchemaUtils.parseOIDs(m.group(9).trim()));
        } else if (m.group(10) != null) {
            nfd.setOptionalAttributes(SchemaUtils.parseOIDs(m.group(10).trim()));
        }
        if (m.group(11) != null) {
            nfd.setExtensions(Extensions.parse(m.group(11).trim()));
        }
        return nfd;
    }

    @Override
    public String format() {
        StringBuilder sb = new StringBuilder("( ");
        sb.append(this.oid).append(" ");
        if (this.getNames() != null && this.getNames().length > 0) {
            sb.append("NAME ");
            sb.append(SchemaUtils.formatDescriptors(this.getNames()));
        }
        if (this.getDescription() != null) {
            sb.append("DESC ");
            sb.append(SchemaUtils.formatDescriptors(this.getDescription()));
        }
        if (this.isObsolete()) {
            sb.append("OBSOLETE ");
        }
        if (this.structuralClass != null) {
            sb.append("OC ").append(this.structuralClass).append(" ");
        }
        if (this.requiredAttributes != null && this.requiredAttributes.length > 0) {
            sb.append("MUST ");
            sb.append(SchemaUtils.formatOids(this.requiredAttributes));
        }
        if (this.optionalAttributes != null && this.optionalAttributes.length > 0) {
            sb.append("MAY ");
            sb.append(SchemaUtils.formatOids(this.optionalAttributes));
        }
        if (this.getExtensions() != null) {
            sb.append(this.getExtensions().format());
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public int hashCode() {
        return LdapUtils.computeHashCode(1163, this.oid, this.getNames(), this.getDescription(), this.isObsolete(), this.structuralClass, this.requiredAttributes, this.optionalAttributes, this.getExtensions());
    }

    public String toString() {
        return String.format("[%s@%d::oid=%s, names=%s, description=%s, obsolete=%s, structuralClass=%s, requiredAttributes=%s, optionalAttributes=%s, extensions=%s]", this.getClass().getName(), this.hashCode(), this.oid, Arrays.toString(this.getNames()), this.getDescription(), this.isObsolete(), this.structuralClass, Arrays.toString(this.requiredAttributes), Arrays.toString(this.optionalAttributes), this.getExtensions());
    }
}

