/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.schema;

import java.text.ParseException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ldaptive.LdapUtils;
import org.ldaptive.schema.AbstractNamedSchemaElement;
import org.ldaptive.schema.Extensions;
import org.ldaptive.schema.ObjectClassType;
import org.ldaptive.schema.SchemaUtils;

public class ObjectClass
extends AbstractNamedSchemaElement {
    private static final int HASH_CODE_SEED = 1109;
    private static final Pattern DEFINITION_PATTERN = Pattern.compile("[ ]*\\([ ]*([^ ]+)[ ]*(?:NAME (?:'([^']+)'|\\(([^\\)]+)\\)))?[ ]*(?:DESC '([^']*)')?[ ]*(OBSOLETE)?[ ]*(?:SUP (?:([^ ]+)|\\(([^\\)]+)\\)))?[ ]*(\\p{Alpha}+)?[ ]*(?:MUST (?:([^ ]+)|\\(([^\\)]+)\\)))?[ ]*(?:MAY (?:([^ ]+)|\\(([^\\)]+)\\)))?[ ]*(?:(X-[^ ]+.*))?[ ]*\\)[ ]*");
    private final String oid;
    private String[] superiorClasses;
    private ObjectClassType objectClassType;
    private String[] requiredAttributes;
    private String[] optionalAttributes;

    public ObjectClass(String s) {
        this.oid = s;
    }

    public ObjectClass(String oid, String[] names, String description, boolean obsolete, String[] superiorClasses, ObjectClassType objectClassType, String[] requiredAttributes, String[] optionalAttributes, Extensions extensions) {
        this(oid);
        this.setNames(names);
        this.setDescription(description);
        this.setObsolete(obsolete);
        this.setSuperiorClasses(superiorClasses);
        this.setObjectClassType(objectClassType);
        this.setRequiredAttributes(requiredAttributes);
        this.setOptionalAttributes(optionalAttributes);
        this.setExtensions(extensions);
    }

    public String getOID() {
        return this.oid;
    }

    public String[] getSuperiorClasses() {
        return this.superiorClasses;
    }

    public void setSuperiorClasses(String[] s) {
        this.superiorClasses = s;
    }

    public ObjectClassType getObjectClassType() {
        return this.objectClassType;
    }

    public void setObjectClassType(ObjectClassType type) {
        this.objectClassType = type;
    }

    public String[] getRequiredAttributes() {
        return this.requiredAttributes;
    }

    public void setRequiredAttributes(String[] s) {
        this.requiredAttributes = s;
    }

    public String[] getOptionalAttributes() {
        return this.optionalAttributes;
    }

    public void setOptionalAttributes(String[] s) {
        this.optionalAttributes = s;
    }

    public static ObjectClass parse(String definition) throws ParseException {
        Matcher m = DEFINITION_PATTERN.matcher(definition);
        if (!m.matches()) {
            throw new ParseException("Invalid object class definition: " + definition, definition.length());
        }
        ObjectClass ocd = new ObjectClass(m.group(1).trim());
        if (m.group(2) != null) {
            ocd.setNames(SchemaUtils.parseDescriptors(m.group(2).trim()));
        } else if (m.group(3) != null) {
            ocd.setNames(SchemaUtils.parseDescriptors(m.group(3).trim()));
        }
        ocd.setDescription(m.group(4) != null ? m.group(4).trim() : null);
        ocd.setObsolete(m.group(5) != null);
        if (m.group(6) != null) {
            ocd.setSuperiorClasses(SchemaUtils.parseOIDs(m.group(6).trim()));
        } else if (m.group(7) != null) {
            ocd.setSuperiorClasses(SchemaUtils.parseOIDs(m.group(7).trim()));
        }
        if (m.group(8) != null) {
            ocd.setObjectClassType(ObjectClassType.valueOf(m.group(8).trim()));
        }
        if (m.group(9) != null) {
            ocd.setRequiredAttributes(SchemaUtils.parseOIDs(m.group(9).trim()));
        } else if (m.group(10) != null) {
            ocd.setRequiredAttributes(SchemaUtils.parseOIDs(m.group(10).trim()));
        }
        if (m.group(11) != null) {
            ocd.setOptionalAttributes(SchemaUtils.parseOIDs(m.group(11).trim()));
        } else if (m.group(12) != null) {
            ocd.setOptionalAttributes(SchemaUtils.parseOIDs(m.group(12).trim()));
        }
        if (m.group(13) != null) {
            ocd.setExtensions(Extensions.parse(m.group(13).trim()));
        }
        return ocd;
    }

    @Override
    public String format() {
        StringBuilder sb = new StringBuilder("( ");
        sb.append(this.oid).append(" ");
        if (this.getNames() != null && this.getNames().length > 0) {
            sb.append("NAME ");
            sb.append(SchemaUtils.formatDescriptors(this.getNames()));
        }
        if (this.getDescription() != null) {
            sb.append("DESC ");
            sb.append(SchemaUtils.formatDescriptors(this.getDescription()));
        }
        if (this.isObsolete()) {
            sb.append("OBSOLETE ");
        }
        if (this.superiorClasses != null && this.superiorClasses.length > 0) {
            sb.append("SUP ");
            sb.append(SchemaUtils.formatOids(this.superiorClasses));
        }
        if (this.objectClassType != null) {
            sb.append(this.objectClassType.name()).append(" ");
        }
        if (this.requiredAttributes != null && this.requiredAttributes.length > 0) {
            sb.append("MUST ");
            sb.append(SchemaUtils.formatOids(this.requiredAttributes));
        }
        if (this.optionalAttributes != null && this.optionalAttributes.length > 0) {
            sb.append("MAY ");
            sb.append(SchemaUtils.formatOids(this.optionalAttributes));
        }
        if (this.getExtensions() != null) {
            sb.append(this.getExtensions().format());
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public int hashCode() {
        return LdapUtils.computeHashCode(1109, new Object[]{this.oid, this.getNames(), this.getDescription(), this.isObsolete(), this.superiorClasses, this.objectClassType, this.requiredAttributes, this.optionalAttributes, this.getExtensions()});
    }

    public String toString() {
        return String.format("[%s@%d::oid=%s, names=%s, description=%s, obsolete=%s, superiorClasses=%s, objectClassType=%s, requiredAttributes=%s, optionalAttributes=%s, extensions=%s]", new Object[]{this.getClass().getName(), this.hashCode(), this.oid, Arrays.toString(this.getNames()), this.getDescription(), this.isObsolete(), Arrays.toString(this.superiorClasses), this.objectClassType, Arrays.toString(this.requiredAttributes), Arrays.toString(this.optionalAttributes), this.getExtensions()});
    }
}

