/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.ssl;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateTrustManager
implements X509TrustManager {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final X509TrustManager[] trustManagers;
    private final Strategy trustStrategy;

    public AggregateTrustManager(X509TrustManager ... managers) {
        this(Strategy.ALL, managers);
    }

    public AggregateTrustManager(Strategy strategy, X509TrustManager ... managers) {
        if (strategy == null) {
            throw new NullPointerException("Strategy cannot be null");
        }
        this.trustStrategy = strategy;
        this.trustManagers = managers;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.trustManagers != null) {
            CertificateException certEx = null;
            for (X509TrustManager tm : this.trustManagers) {
                try {
                    tm.checkClientTrusted(chain, authType);
                    this.logger.debug("checkClientTrusted for {} succeeded", (Object)tm);
                    if (this.trustStrategy != Strategy.ANY) continue;
                    return;
                }
                catch (CertificateException e) {
                    this.logger.debug("checkClientTrusted for {} failed", (Object)tm);
                    if (this.trustStrategy == Strategy.ALL) {
                        throw e;
                    }
                    if (certEx != null) continue;
                    certEx = e;
                }
            }
            if (certEx != null) {
                throw certEx;
            }
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.trustManagers != null) {
            CertificateException certEx = null;
            for (X509TrustManager tm : this.trustManagers) {
                try {
                    tm.checkServerTrusted(chain, authType);
                    this.logger.debug("checkServerTrusted for {} succeeded", (Object)tm);
                    if (this.trustStrategy != Strategy.ANY) continue;
                    return;
                }
                catch (CertificateException e) {
                    this.logger.debug("checkServerTrusted for {} failed", (Object)tm);
                    if (this.trustStrategy == Strategy.ALL) {
                        throw e;
                    }
                    if (certEx != null) continue;
                    certEx = e;
                }
            }
            if (certEx != null) {
                throw certEx;
            }
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        ArrayList issuers = new ArrayList();
        if (this.trustManagers != null) {
            for (X509TrustManager tm : this.trustManagers) {
                this.logger.debug("invoking getAcceptedIssuers invoked for {}", (Object)tm);
                Collections.addAll(issuers, tm.getAcceptedIssuers());
            }
        }
        return issuers.toArray(new X509Certificate[issuers.size()]);
    }

    public String toString() {
        return String.format("[%s@%d::trustManagers=%s, trustStrategy=%s]", new Object[]{this.getClass().getName(), this.hashCode(), Arrays.toString(this.trustManagers), this.trustStrategy});
    }

    public static enum Strategy {
        ALL,
        ANY;

    }
}

