/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.ssl;

import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.ldaptive.LdapUtils;
import org.ldaptive.asn1.DN;
import org.ldaptive.asn1.RDN;
import org.ldaptive.io.StringValueTranscoder;
import org.ldaptive.ssl.CertificateHostnameVerifier;
import org.ldaptive.ssl.TLSSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHostnameVerifier
implements HostnameVerifier,
CertificateHostnameVerifier {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public boolean verify(String hostname, SSLSession session) {
        boolean b = false;
        try {
            String name = null;
            if (hostname != null) {
                name = hostname.startsWith("[") && hostname.endsWith("]") ? hostname.substring(1, hostname.length() - 1).trim() : hostname.trim();
            }
            b = this.verify(name, (X509Certificate)session.getPeerCertificates()[0]);
        }
        catch (SSLPeerUnverifiedException e) {
            this.logger.warn("Could not get certificate from the SSL session", (Throwable)e);
        }
        return b;
    }

    @Override
    public boolean verify(String hostname, X509Certificate cert) {
        this.logger.debug("verifying hostname={} against cert={}", (Object)hostname, (Object)cert.getSubjectX500Principal().toString());
        boolean b = LdapUtils.isIPAddress(hostname) ? this.verifyIP(hostname, cert) : this.verifyDNS(hostname, cert);
        return b;
    }

    protected boolean verifyIP(String ip, X509Certificate cert) {
        Object[] subjAltNames = this.getSubjectAltNames(cert, SubjectAltNameType.IP_ADDRESS);
        this.logger.debug("verifyIP using subjectAltNames={}", (Object)Arrays.toString(subjAltNames));
        for (Object name : subjAltNames) {
            if (!ip.equalsIgnoreCase((String)name)) continue;
            this.logger.debug("verifyIP found hostname match: {}", name);
            return true;
        }
        return false;
    }

    protected boolean verifyDNS(String hostname, X509Certificate cert) {
        boolean verified = false;
        Object[] subjAltNames = this.getSubjectAltNames(cert, SubjectAltNameType.DNS_NAME);
        this.logger.debug("verifyDNS using subjectAltNames={}", (Object)Arrays.toString(subjAltNames));
        if (subjAltNames.length > 0) {
            for (Object name : subjAltNames) {
                if (!this.isMatch(hostname, (String)name)) continue;
                this.logger.debug("verifyDNS found hostname match: {}", name);
                verified = true;
                break;
            }
        } else {
            Object[] cns = this.getCNs(cert);
            this.logger.debug("verifyDNS using CN={}", (Object)Arrays.toString(cns));
            if (cns.length > 0 && this.isMatch(hostname, (String)cns[cns.length - 1])) {
                this.logger.debug("verifyDNS found hostname match: {}", cns[cns.length - 1]);
                verified = true;
            }
        }
        return verified;
    }

    private String[] getSubjectAltNames(X509Certificate cert, SubjectAltNameType type) {
        ArrayList<String> names = new ArrayList<String>();
        try {
            Collection<List<?>> subjAltNames = cert.getSubjectAlternativeNames();
            if (subjAltNames != null) {
                for (List<?> generalName : subjAltNames) {
                    Integer nameType = (Integer)generalName.get(0);
                    if (nameType.intValue() != type.ordinal()) continue;
                    names.add((String)generalName.get(1));
                }
            }
        }
        catch (CertificateParsingException e) {
            this.logger.warn("Error reading subject alt names from certificate", (Throwable)e);
        }
        return names.toArray(new String[names.size()]);
    }

    private String[] getCNs(X509Certificate cert) {
        ArrayList<String> names = new ArrayList<String>();
        byte[] encodedDn = cert.getSubjectX500Principal().getEncoded();
        if (encodedDn != null && encodedDn.length > 0) {
            DN dn = DN.decode(ByteBuffer.wrap(encodedDn));
            for (RDN rdn : dn.getRDNs()) {
                String value = rdn.getAttributeValue("2.5.4.3", new StringValueTranscoder());
                if (value == null) continue;
                names.add(value);
            }
        }
        return names.toArray(new String[names.size()]);
    }

    private boolean isMatch(String hostname, String certName) {
        boolean match;
        boolean isWildcard = certName.startsWith("*.") && certName.indexOf(46) < certName.lastIndexOf(46);
        this.logger.trace("matching for hostname={}, certName={}, isWildcard={}", new Object[]{hostname, certName, isWildcard});
        if (isWildcard) {
            String certNameDomain = certName.substring(certName.indexOf("."));
            int hostnameIdx = hostname.contains(".") ? hostname.indexOf(".") : hostname.length();
            String hostnameDomain = hostname.substring(hostnameIdx);
            match = certNameDomain.equalsIgnoreCase(hostnameDomain);
            this.logger.trace("match={} for {} == {}", new Object[]{match, certNameDomain, hostnameDomain});
        } else {
            match = certName.equalsIgnoreCase(hostname);
            this.logger.trace("match={} for {} == {}", new Object[]{match, certName, hostname});
        }
        return match;
    }

    public static class SSLSocketFactory
    extends TLSSocketFactory {
        public SSLSocketFactory() {
            this.setHostnameVerifier(new DefaultHostnameVerifier());
        }

        public static SocketFactory getDefault() {
            SSLSocketFactory sf = new SSLSocketFactory();
            try {
                sf.initialize();
            }
            catch (GeneralSecurityException e) {
                LoggerFactory.getLogger(SSLSocketFactory.class).error("Error initializing socket factory", (Throwable)e);
            }
            return sf;
        }
    }

    private static enum SubjectAltNameType {
        OTHER_NAME,
        RFC822_NAME,
        DNS_NAME,
        X400_ADDRESS,
        DIRECTORY_NAME,
        EDI_PARTY_NAME,
        UNIFORM_RESOURCE_IDENTIFIER,
        IP_ADDRESS,
        REGISTERED_ID;

    }
}

