/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.ssl;

import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Arrays;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.ldaptive.ssl.AbstractSSLContextInitializer;
import org.ldaptive.ssl.KeyStoreUtils;

public class KeyStoreSSLContextInitializer
extends AbstractSSLContextInitializer {
    private KeyStore trustKeystore;
    private String[] trustAliases;
    private KeyStore authenticationKeystore;
    private String[] authenticationAliases;
    private char[] authenticationPassword;

    public void setTrustKeystore(KeyStore keystore) {
        this.trustKeystore = keystore;
    }

    public void setTrustAliases(String ... aliases) {
        this.trustAliases = aliases;
    }

    public void setAuthenticationKeystore(KeyStore keystore) {
        this.authenticationKeystore = keystore;
    }

    public void setAuthenticationAliases(String ... aliases) {
        this.authenticationAliases = aliases;
    }

    public void setAuthenticationPassword(char[] password) {
        this.authenticationPassword = password;
    }

    @Override
    protected TrustManager[] createTrustManagers() throws GeneralSecurityException {
        TrustManager[] tm = null;
        if (this.trustKeystore != null) {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            if (this.trustAliases != null) {
                KeyStore ks = KeyStoreUtils.newInstance();
                for (String alias : this.trustAliases) {
                    KeyStore.Entry entry = KeyStoreUtils.getEntry(alias, this.trustKeystore, null);
                    KeyStoreUtils.setEntry(alias, entry, ks, null);
                }
                tmf.init(ks);
            } else {
                tmf.init(this.trustKeystore);
            }
            tm = tmf.getTrustManagers();
        }
        return tm;
    }

    @Override
    public KeyManager[] getKeyManagers() throws GeneralSecurityException {
        KeyManager[] km = null;
        if (this.authenticationKeystore != null && this.authenticationPassword != null) {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            if (this.authenticationAliases != null) {
                KeyStore ks = KeyStoreUtils.newInstance(this.authenticationPassword);
                for (String alias : this.authenticationAliases) {
                    KeyStore.Entry entry = KeyStoreUtils.getEntry(alias, this.authenticationKeystore, this.authenticationPassword);
                    KeyStoreUtils.setEntry(alias, entry, ks, this.authenticationPassword);
                }
                kmf.init(ks, this.authenticationPassword);
            } else {
                kmf.init(this.authenticationKeystore, this.authenticationPassword);
            }
            km = kmf.getKeyManagers();
        }
        return km;
    }

    public String toString() {
        return String.format("[%s@%d::trustManagers=%s, trustKeystore=%s, trustAliases=%s, authenticationKeystore=%s, authenticationAliases=%s]", this.getClass().getName(), this.hashCode(), Arrays.toString(this.trustManagers), this.trustKeystore, Arrays.toString(this.trustAliases), this.authenticationKeystore, Arrays.toString(this.authenticationAliases));
    }
}

