/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractExtractionAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.UsernamePasswordContext;
import net.shibboleth.utilities.java.support.collection.Pair;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.soap11.Header;
import org.opensaml.soap.wssecurity.Password;
import org.opensaml.soap.wssecurity.Security;
import org.opensaml.soap.wssecurity.Username;
import org.opensaml.soap.wssecurity.UsernameToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractUsernamePasswordFromWSSToken
extends AbstractExtractionAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ExtractUsernamePasswordFromWSSToken.class);
    @Nullable
    private Envelope inboundMessage;

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        MessageContext inCtx = profileRequestContext.getInboundMessageContext();
        if (inCtx == null || !(inCtx.getMessage() instanceof Envelope)) {
            this.log.debug("{} Inbound message context missing or doesn't contain a SOAP Envelope", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            return false;
        }
        this.inboundMessage = (Envelope)inCtx.getMessage();
        return super.doPreExecute(profileRequestContext, authenticationContext);
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        Pair<String, String> usernamePassword = this.extractUsernamePassword(this.inboundMessage);
        if (usernamePassword == null) {
            this.log.debug("{} inbound message does not contain a username and password", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            return;
        }
        ((UsernamePasswordContext)authenticationContext.getSubcontext(UsernamePasswordContext.class, true)).setUsername((String)usernamePassword.getFirst()).setPassword((String)usernamePassword.getSecond());
    }

    @Nullable
    private Pair<String, String> extractUsernamePassword(@Nonnull Envelope message) {
        UsernameToken usernameToken = this.getUsernameToken(message);
        if (usernameToken == null) {
            return null;
        }
        Username username = usernameToken.getUsername();
        if (username == null) {
            this.log.debug("{} <UsernameToken> does not contain a <Username>", (Object)this.getLogPrefix());
            return null;
        }
        List passwords = usernameToken.getUnknownXMLObjects(Password.ELEMENT_NAME);
        if (passwords == null || passwords.size() == 0) {
            this.log.debug("{} <UsernameToken> does not contain a <Password>", (Object)this.getLogPrefix());
            return null;
        }
        Iterator passwordsItr = passwords.iterator();
        Password password = null;
        while (passwordsItr.hasNext()) {
            password = (Password)passwordsItr.next();
            if (password.getType() == null || password.getType().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd#PasswordText")) continue;
            this.log.debug("{} Skipping password with unsupported type {}", (Object)this.getLogPrefix(), (Object)password.getType());
            password = null;
        }
        if (password == null) {
            this.log.debug("{} <UsernameToken> does not contain a support <Password>", (Object)this.getLogPrefix());
            return null;
        }
        return new Pair((Object)username.getValue(), (Object)password.getValue());
    }

    @Nullable
    private UsernameToken getUsernameToken(@Nonnull Envelope message) {
        Header header = message.getHeader();
        List securityHeaders = header.getUnknownXMLObjects(Security.ELEMENT_NAME);
        if (securityHeaders == null || securityHeaders.size() == 0) {
            this.log.debug("{} Inbound message does not contain <Security>", (Object)this.getLogPrefix());
            return null;
        }
        List usernameTokens = ((Security)securityHeaders.get(0)).getUnknownXMLObjects(UsernameToken.ELEMENT_NAME);
        if (usernameTokens == null || usernameTokens.size() == 0) {
            this.log.debug("{} Inbound message security header does not contain <UsernameToken>", (Object)this.getLogPrefix());
            return null;
        }
        return (UsernameToken)usernameTokens.get(0);
    }
}

