/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import java.security.Principal;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterFlowsByAttribute
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(FilterFlowsByAttribute.class);
    @Nonnull
    private Function<ProfileRequestContext, AttributeContext> attributeContextLookupStrategy = Functions.compose((Function)new ChildContextLookup(AttributeContext.class), (Function)new ChildContextLookup(AuthenticationContext.class));
    @Nullable
    private String attributeId;
    private boolean filterActiveResults = true;
    @Nullable
    private IdPAttribute attribute;

    public void setAttributeContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.attributeContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeContext lookup strategy cannot be null");
    }

    public void setAttributeId(@Nullable String id) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.attributeId = StringSupport.trimOrNull((String)id);
    }

    public void setFilterActiveResults(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.filterActiveResults = flag;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext) || this.attributeId == null) {
            return false;
        }
        AttributeContext attributeCtx = (AttributeContext)this.attributeContextLookupStrategy.apply((Object)profileRequestContext);
        if (attributeCtx == null) {
            this.log.debug("{} Request does not contain an AttributeContext, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        this.attribute = (IdPAttribute)attributeCtx.getIdPAttributes().get(this.attributeId);
        if (this.attribute == null || this.attribute.getValues().isEmpty()) {
            this.log.debug("{} Attribute {} has no values, nothing to do", (Object)this.getLogPrefix(), (Object)this.attributeId);
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        this.log.debug("{} Filtering inactive flows available for use", (Object)this.getLogPrefix());
        Map potentialFlows = authenticationContext.getPotentialFlows();
        Iterator descriptorItr = potentialFlows.entrySet().iterator();
        while (descriptorItr.hasNext()) {
            AuthenticationFlowDescriptor descriptor = (AuthenticationFlowDescriptor)descriptorItr.next().getValue();
            String match = this.getMatch(descriptor);
            if (match != null) {
                this.log.debug("{} Retaining flow {}, matched custom Principal {}", new Object[]{this.getLogPrefix(), descriptor.getId(), match});
                continue;
            }
            this.log.debug("{} Removing flow {}, Principals did not match any attribute values", (Object)this.getLogPrefix(), (Object)descriptor.getId());
            descriptorItr.remove();
        }
        if (potentialFlows.size() == 0) {
            this.log.info("{} No potential authentication flows remain after filtering", (Object)this.getLogPrefix());
        } else {
            this.log.debug("{} Potential authentication flows left after filtering: {}", (Object)this.getLogPrefix(), (Object)potentialFlows);
        }
        if (this.filterActiveResults) {
            this.log.debug("{} Filtering active results available for reuse", (Object)this.getLogPrefix());
            Map activeResults = authenticationContext.getActiveResults();
            Iterator resultItr = activeResults.entrySet().iterator();
            while (resultItr.hasNext()) {
                AuthenticationResult result = (AuthenticationResult)resultItr.next().getValue();
                String match = this.getMatch(result);
                if (match != null) {
                    this.log.debug("{} Retaining active result from flow {}, matched custom Principal {}", new Object[]{this.getLogPrefix(), result.getAuthenticationFlowId(), match});
                    continue;
                }
                this.log.debug("{} Removing active result from flow {}, Principals did not match any attribute values", (Object)this.getLogPrefix(), (Object)result.getAuthenticationFlowId());
                resultItr.remove();
            }
            if (activeResults.size() == 0) {
                this.log.info("{} No active authentication results remain after filtering", (Object)this.getLogPrefix());
            } else {
                this.log.debug("{} Active authentication results left after filtering: {}", (Object)this.getLogPrefix(), (Object)activeResults);
            }
        }
    }

    @Nullable
    private String getMatch(@Nonnull AuthenticationFlowDescriptor flow) {
        this.log.debug("{} Looking for match for flow {} against values for attribute {}", new Object[]{this.getLogPrefix(), flow.getId(), this.attribute.getId()});
        for (Principal p : flow.getSupportedPrincipals()) {
            this.log.debug("{} Comparing principal {} against attribute values {}", new Object[]{this.getLogPrefix(), p.getName(), this.attribute.getValues()});
            for (IdPAttributeValue val : this.attribute.getValues()) {
                if (!(val instanceof StringAttributeValue) || !Objects.equals(val.getValue(), p.getName())) continue;
                return p.getName();
            }
        }
        return null;
    }

    @Nullable
    private String getMatch(@Nonnull AuthenticationResult result) {
        this.log.debug("{} Looking for match for active result of flow {} against values for attribute {}", new Object[]{this.getLogPrefix(), result.getAuthenticationFlowId(), this.attribute.getId()});
        for (Principal p : result.getSupportedPrincipals(Principal.class)) {
            this.log.debug("{} Comparing principal {} against attribute values {}", new Object[]{this.getLogPrefix(), p.getName(), this.attribute.getValues()});
            for (IdPAttributeValue val : this.attribute.getValues()) {
                if (!(val instanceof StringAttributeValue) || !Objects.equals(val.getValue(), p.getName())) continue;
                return p.getName();
            }
        }
        return null;
    }
}

