/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterFlowsByPassivity
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(FilterFlowsByPassivity.class);

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!authenticationContext.isPassive()) {
            this.log.debug("{} Request does not have passive requirement, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        return super.doPreExecute(profileRequestContext, authenticationContext);
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        Map potentialFlows = authenticationContext.getPotentialFlows();
        Iterator descriptorItr = potentialFlows.entrySet().iterator();
        while (descriptorItr.hasNext()) {
            AuthenticationFlowDescriptor descriptor = (AuthenticationFlowDescriptor)descriptorItr.next().getValue();
            if (descriptor.isPassiveAuthenticationSupported()) {
                this.log.debug("{} Retaining flow {}, it supports passive authentication", (Object)this.getLogPrefix(), (Object)descriptor.getId());
                continue;
            }
            this.log.debug("{} Removing flow {}, it does not support passive authentication", (Object)this.getLogPrefix(), (Object)descriptor.getId());
            descriptorItr.remove();
        }
        if (potentialFlows.size() == 0) {
            this.log.info("{} No potential authentication flows remain after filtering", (Object)this.getLogPrefix());
        } else {
            this.log.debug("{} Potential authentication flows left after filtering: {}", (Object)this.getLogPrefix(), (Object)potentialFlows);
        }
    }
}

