/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.impl.PopulateAuthenticationContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreserveAuthenticationFlowState
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateAuthenticationContext.class);
    @Nonnull
    @NonnullElements
    private Collection<String> parameterNames = Collections.emptyList();

    PreserveAuthenticationFlowState() {
    }

    public void setParameterNames(@Nullable @NonnullElements Collection<String> names) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.parameterNames = names == null ? Collections.emptyList() : new ArrayList<String>(StringSupport.normalizeStringCollection(names));
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        if (this.getHttpServletRequest() == null) {
            this.log.debug("No HttpServletRequest available");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        Map state = authenticationContext.getAuthenticationStateMap();
        state.clear();
        Map params = this.getHttpServletRequest().getParameterMap();
        for (String name : this.parameterNames) {
            String[] values = (String[])params.get(name);
            if (values == null) continue;
            if (values.length == 0) {
                state.put(name, null);
                continue;
            }
            if (values.length == 1) {
                state.put(name, values[0]);
                continue;
            }
            state.put(name, Arrays.asList(values));
        }
    }
}

