/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import net.shibboleth.idp.authn.AbstractUsernamePasswordValidationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateUsernamePasswordAgainstJAAS
extends AbstractUsernamePasswordValidationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateUsernamePasswordAgainstJAAS.class);
    @Nullable
    private String loginConfigType;
    @Nullable
    private Configuration.Parameters loginConfigParameters;
    @Nonnull
    @NonnullElements
    private List<String> loginConfigNames = Collections.singletonList("ShibUserPassAuth");

    @Nullable
    public String getLoginConfigType() {
        return this.loginConfigType;
    }

    public void setLoginConfigType(@Nullable String type) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.loginConfigType = StringSupport.trimOrNull((String)type);
    }

    @Nullable
    public Configuration.Parameters getLoginConfigParameters() {
        return this.loginConfigParameters;
    }

    public void setLoginConfigParameters(@Nullable Configuration.Parameters params) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.loginConfigParameters = params;
    }

    public void setLoginConfigNames(@Nonnull @NonnullElements @NotEmpty List<String> names) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(names, (String)"Configuration name list cannot be null");
        this.loginConfigNames = new ArrayList<String>(StringSupport.normalizeStringCollection(names));
        if (this.loginConfigNames.isEmpty()) {
            throw new ConstraintViolationException("Configuration name list cannot be empty");
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        for (String loginConfigName : this.loginConfigNames) {
            try {
                this.log.debug("{} Attempting to authenticate user '{}'", (Object)this.getLogPrefix(), (Object)this.getUsernamePasswordContext().getUsername());
                this.authenticate(loginConfigName);
                this.log.info("{} Login by '{}' succeeded", (Object)this.getLogPrefix(), (Object)this.getUsernamePasswordContext().getUsername());
                this.buildAuthenticationResult(profileRequestContext, authenticationContext);
                ActionSupport.buildProceedEvent((ProfileRequestContext)profileRequestContext);
                return;
            }
            catch (LoginException e) {
                this.log.info("{} Login by {} failed", new Object[]{this.getLogPrefix(), this.getUsernamePasswordContext().getUsername(), e});
                this.handleError(profileRequestContext, authenticationContext, e, "InvalidCredentials");
            }
            catch (Exception e) {
                this.log.warn("{} Login by {} produced exception", new Object[]{this.getLogPrefix(), this.getUsernamePasswordContext().getUsername(), e});
                this.handleError(profileRequestContext, authenticationContext, e, "AuthenticationException");
            }
        }
    }

    private void authenticate(@Nonnull @NotEmpty String loginConfigName) throws LoginException, NoSuchAlgorithmException {
        LoginContext jaasLoginCtx;
        if (this.getLoginConfigType() != null) {
            this.log.debug("{} Using custom JAAS configuration type {} with parameters of type {}", new Object[]{this.getLogPrefix(), this.getLoginConfigType(), this.getLoginConfigParameters().getClass().getName()});
            Configuration loginConfig = Configuration.getInstance(this.getLoginConfigType(), this.getLoginConfigParameters());
            jaasLoginCtx = new LoginContext(loginConfigName, this.getSubject(), new SimpleCallbackHandler(), loginConfig);
        } else {
            this.log.debug("{} Using system JAAS configuration", (Object)this.getLogPrefix());
            jaasLoginCtx = new LoginContext(loginConfigName, this.getSubject(), new SimpleCallbackHandler());
        }
        jaasLoginCtx.login();
    }

    protected class SimpleCallbackHandler
    implements CallbackHandler {
        protected SimpleCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            if (callbacks == null || callbacks.length == 0) {
                return;
            }
            for (Callback cb : callbacks) {
                if (cb instanceof NameCallback) {
                    NameCallback ncb = (NameCallback)cb;
                    ncb.setName(ValidateUsernamePasswordAgainstJAAS.this.getUsernamePasswordContext().getUsername());
                    continue;
                }
                if (!(cb instanceof PasswordCallback)) continue;
                PasswordCallback pcb = (PasswordCallback)cb;
                pcb.setPassword(ValidateUsernamePasswordAgainstJAAS.this.getUsernamePasswordContext().getPassword().toCharArray());
            }
        }
    }
}

