/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import net.shibboleth.idp.authn.AbstractUsernamePasswordValidationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateUsernamePasswordAgainstKerberos
extends AbstractUsernamePasswordValidationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateUsernamePasswordAgainstKerberos.class);
    @NonnullAfterInit
    @NotEmpty
    private String loginModuleClassName = "com.sun.security.auth.module.Krb5LoginModule";
    private boolean refreshKrb5Config;
    private boolean preserveTicket;
    private String servicePrincipal;
    private String keytabPath;
    @NonnullAfterInit
    private Map<String, String> clientOptions;
    @NonnullAfterInit
    private Map<String, String> serverOptions;

    public void setLoginModuleClassName(@Nonnull String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.loginModuleClassName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Class name cannot be null or empty");
    }

    public void setRefreshKrb5Config(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.refreshKrb5Config = flag;
    }

    public void setPreserveTicket(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.preserveTicket = flag;
    }

    public void setServicePrincipal(@Nullable String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.servicePrincipal = StringSupport.trimOrNull((String)name);
    }

    public void setKeytabPath(@Nullable String path) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.keytabPath = path;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.servicePrincipal != null && this.keytabPath == null) {
            throw new ComponentInitializationException("A keytab path is required if a service principal is set");
        }
        this.clientOptions = new HashMap<String, String>();
        this.clientOptions.put("refreshKrb5Config", Boolean.valueOf(this.refreshKrb5Config).toString());
        if (this.servicePrincipal != null) {
            this.serverOptions = new HashMap<String, String>();
            this.serverOptions.put("refreshKrb5Config", Boolean.valueOf(this.refreshKrb5Config).toString());
            this.serverOptions.put("useKeyTab", "true");
            this.serverOptions.put("keyTab", this.keytabPath);
            this.serverOptions.put("principal", this.servicePrincipal);
            this.serverOptions.put("doNotPrompt", "true");
            this.serverOptions.put("isInitiator", "false");
            this.serverOptions.put("storeKey", "true");
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        try {
            LoginModule clientLoginModule = (LoginModule)Class.forName(this.loginModuleClassName).newInstance();
            clientLoginModule.initialize(this.getSubject(), new SimpleCallbackHandler(), new HashMap(), this.clientOptions);
            if (!clientLoginModule.login() || !clientLoginModule.commit()) {
                clientLoginModule.abort();
                throw new LoginException("Login module reported failure");
            }
            if (this.servicePrincipal != null) {
                this.verifyKDC();
            }
            this.log.info("{} Login by '{}' succeeded", (Object)this.getLogPrefix(), (Object)this.getUsernamePasswordContext().getUsername());
            this.buildAuthenticationResult(profileRequestContext, authenticationContext);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            this.log.error("{} Unable to instantiate JAAS module for Kerberos", (Object)this.getLogPrefix(), (Object)e);
            this.handleError(profileRequestContext, authenticationContext, e, "AuthenticationException");
        }
        catch (LoginException e) {
            this.log.info("{} Login by {} failed", new Object[]{this.getLogPrefix(), this.getUsernamePasswordContext().getUsername(), e});
            this.handleError(profileRequestContext, authenticationContext, e, "InvalidCredentials");
        }
        catch (GSSException e) {
            this.log.warn("{} Login by {} failed during GSS context establishment to verify KDC", new Object[]{this.getLogPrefix(), this.getUsernamePasswordContext().getUsername(), e});
            this.handleError(profileRequestContext, authenticationContext, e, "InvalidCredentials");
        }
        catch (Exception e) {
            this.log.warn("{} Login by {} produced unknown exception", new Object[]{this.getLogPrefix(), this.getUsernamePasswordContext().getUsername(), e});
            this.handleError(profileRequestContext, authenticationContext, e, "AuthenticationException");
        }
    }

    @Nonnull
    protected Subject populateSubject(@Nonnull Subject subject) {
        if (!this.preserveTicket) {
            subject.getPrivateCredentials().clear();
        }
        return super.populateSubject(subject);
    }

    private void verifyKDC() throws Exception {
        this.log.debug("{} TGT acquired for {}, attempting to verify authenticity of TGT using service principal {}", new Object[]{this.getLogPrefix(), this.getUsernamePasswordContext().getUsername(), this.servicePrincipal});
        Oid mechOid = new Oid("1.2.840.113554.1.2.2");
        LoginModule serverLoginModule = null;
        try {
            serverLoginModule = (LoginModule)Class.forName(this.loginModuleClassName).newInstance();
            Subject serverSubject = new Subject();
            serverLoginModule.initialize(serverSubject, null, new HashMap(), this.serverOptions);
            if (!serverLoginModule.login() || !serverLoginModule.commit()) {
                serverLoginModule.abort();
                throw new LoginException("Login module reported failure");
            }
            final GSSManager manager = GSSManager.getInstance();
            GSSName serviceName = manager.createName(this.servicePrincipal, GSSName.NT_USER_NAME);
            final GSSContext context = manager.createContext(serviceName, mechOid, null, 0);
            final byte[] token = Subject.doAs(this.getSubject(), new PrivilegedExceptionAction<byte[]>(){

                @Override
                public byte[] run() throws GSSException {
                    byte[] token = new byte[]{};
                    context.requestMutualAuth(false);
                    context.requestCredDeleg(false);
                    return context.initSecContext(token, 0, token.length);
                }
            });
            String verifiedName = Subject.doAs(serverSubject, new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws GSSException {
                    GSSContext serverCtx = manager.createContext((GSSCredential)null);
                    serverCtx.acceptSecContext(token, 0, token.length);
                    String s = serverCtx.getSrcName().toString();
                    serverCtx.dispose();
                    return s;
                }
            });
            context.dispose();
            this.log.debug("{} GSS context established between {} and {}", new Object[]{this.getLogPrefix(), verifiedName, this.servicePrincipal});
        }
        catch (LoginException e) {
            throw new LoginException("Unable to obtain service credentials for KDC verification");
        }
        catch (PrivilegedActionException e) {
            if (e.getException() != null) {
                throw e.getException();
            }
            throw e;
        }
        finally {
            if (serverLoginModule != null) {
                serverLoginModule.logout();
            }
        }
    }

    private class SimpleCallbackHandler
    implements CallbackHandler {
        private SimpleCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            if (callbacks == null || callbacks.length == 0) {
                return;
            }
            for (Callback cb : callbacks) {
                if (cb instanceof NameCallback) {
                    NameCallback ncb = (NameCallback)cb;
                    ncb.setName(ValidateUsernamePasswordAgainstKerberos.this.getUsernamePasswordContext().getUsername());
                    continue;
                }
                if (!(cb instanceof PasswordCallback)) continue;
                PasswordCallback pcb = (PasswordCallback)cb;
                pcb.setPassword(ValidateUsernamePasswordAgainstKerberos.this.getUsernamePasswordContext().getPassword().toCharArray());
            }
        }
    }
}

