/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.security.Principal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AbstractUsernamePasswordValidationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.LDAPResponseContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.ldaptive.Credential;
import org.ldaptive.LdapException;
import org.ldaptive.ResultCode;
import org.ldaptive.auth.AccountState;
import org.ldaptive.auth.AuthenticationRequest;
import org.ldaptive.auth.AuthenticationResponse;
import org.ldaptive.auth.AuthenticationResultCode;
import org.ldaptive.auth.Authenticator;
import org.ldaptive.jaas.LdapPrincipal;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateUsernamePasswordAgainstLDAP
extends AbstractUsernamePasswordValidationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateUsernamePasswordAgainstLDAP.class);
    @Nonnull
    private Authenticator authenticator;
    @Nullable
    private String[] returnAttributes;
    @Nullable
    private AuthenticationResponse response;

    @NonnullAfterInit
    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(@Nonnull Authenticator auth) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.authenticator = (Authenticator)Constraint.isNotNull((Object)auth, (String)"Authenticator cannot be null");
    }

    @Nullable
    public String[] getReturnAttributes() {
        return this.returnAttributes;
    }

    public void setReturnAttributes(String ... attributes) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.returnAttributes = attributes;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.authenticator == null) {
            throw new ComponentInitializationException("Authenticator cannot be null");
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        block7: {
            try {
                this.log.debug("{} Attempting to authenticate user {}", (Object)this.getLogPrefix(), (Object)this.getUsernamePasswordContext().getUsername());
                AuthenticationRequest request = new AuthenticationRequest(this.getUsernamePasswordContext().getUsername(), new Credential(this.getUsernamePasswordContext().getPassword()), this.returnAttributes);
                this.response = this.authenticator.authenticate(request);
                this.log.trace("{} Authentication response {}", (Object)this.getLogPrefix(), (Object)this.response);
                if (((Boolean)this.response.getResult()).booleanValue()) {
                    this.log.info("{} Login by '{}' succeeded", (Object)this.getLogPrefix(), (Object)this.getUsernamePasswordContext().getUsername());
                    ((LDAPResponseContext)authenticationContext.getSubcontext(LDAPResponseContext.class, true)).setAuthenticationResponse(this.response);
                    if (this.response.getAccountState() != null) {
                        AccountState.Error error = this.response.getAccountState().getError();
                        this.handleWarning(profileRequestContext, authenticationContext, String.format("%s:%s:%s", error != null ? error : "ACCOUNT_WARNING", this.response.getResultCode(), this.response.getMessage()), "AccountWarning");
                    }
                    this.buildAuthenticationResult(profileRequestContext, authenticationContext);
                    break block7;
                }
                this.log.info("{} Login by '{}' failed", (Object)this.getLogPrefix(), (Object)this.getUsernamePasswordContext().getUsername());
                ((LDAPResponseContext)authenticationContext.getSubcontext(LDAPResponseContext.class, true)).setAuthenticationResponse(this.response);
                if (AuthenticationResultCode.DN_RESOLUTION_FAILURE == this.response.getAuthenticationResultCode() || AuthenticationResultCode.INVALID_CREDENTIAL == this.response.getAuthenticationResultCode()) {
                    this.handleError(profileRequestContext, authenticationContext, String.format("%s:%s", this.response.getAuthenticationResultCode(), this.response.getMessage()), "InvalidCredentials");
                    break block7;
                }
                if (this.response.getAccountState() != null) {
                    AccountState state = this.response.getAccountState();
                    this.handleError(profileRequestContext, authenticationContext, String.format("%s:%s:%s", state.getError(), this.response.getResultCode(), this.response.getMessage()), "AccountError");
                    break block7;
                }
                if (this.response.getResultCode() == ResultCode.INVALID_CREDENTIALS) {
                    this.handleError(profileRequestContext, authenticationContext, String.format("%s:%s", this.response.getResultCode(), this.response.getMessage()), "InvalidCredentials");
                    break block7;
                }
                throw new LdapException(this.response.getMessage(), this.response.getResultCode(), this.response.getMatchedDn(), this.response.getControls(), this.response.getReferralURLs(), this.response.getMessageId());
            }
            catch (LdapException e) {
                this.log.warn("{} Login by {} produced exception", new Object[]{this.getLogPrefix(), this.getUsernamePasswordContext().getUsername(), e});
                this.handleError(profileRequestContext, authenticationContext, (Exception)((Object)e), "AuthenticationException");
            }
        }
    }

    @Nonnull
    protected Subject populateSubject(@Nonnull Subject subject) {
        subject.getPrincipals().add((Principal)new LdapPrincipal(this.getUsernamePasswordContext().getUsername(), this.response.getLdapEntry()));
        return super.populateSubject(subject);
    }
}

