/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.principal.impl;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.Principal;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.stream.JsonGenerator;
import net.shibboleth.idp.authn.principal.AbstractPrincipalSerializer;
import net.shibboleth.idp.authn.principal.PasswordPrincipal;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import net.shibboleth.utilities.java.support.xml.DOMTypeSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class PasswordPrincipalSerializer
extends AbstractPrincipalSerializer<String> {
    @Nonnull
    @NotEmpty
    private static final String PASSWORD_FIELD = "PW";
    private static final Pattern JSON_PATTERN = Pattern.compile("^\\{\"PW\":.*\\}$");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PasswordPrincipalSerializer.class);
    @NonnullAfterInit
    private DataSealer sealer;
    @Nonnull
    private final JsonBuilderFactory objectBuilderFactory = Json.createBuilderFactory(null);

    public void setDataSealer(@Nonnull DataSealer theSealer) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.sealer = (DataSealer)Constraint.isNotNull((Object)theSealer, (String)"DataSealer cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.sealer == null) {
            throw new ComponentInitializationException("DataSealer cannot be null");
        }
    }

    public boolean supports(@Nonnull Principal principal) {
        return principal instanceof PasswordPrincipal;
    }

    @Nonnull
    @NotEmpty
    public String serialize(@Nonnull Principal principal) throws IOException {
        StringWriter sink = new StringWriter(32);
        JsonGenerator gen = this.getJsonGenerator(sink);
        try {
            gen.writeStartObject().write(PASSWORD_FIELD, this.sealer.wrap(principal.getName(), System.currentTimeMillis() + DOMTypeSupport.durationToLong((String)"P1Y"))).writeEnd();
        }
        catch (DataSealerException e) {
            throw new IOException(e);
        }
        gen.close();
        return sink.toString();
    }

    public boolean supports(@Nonnull @NotEmpty String value) {
        return JSON_PATTERN.matcher(value).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public PasswordPrincipal deserialize(@Nonnull @NotEmpty String value) throws IOException {
        JsonStructure st = null;
        try (JsonReader reader = this.getJsonReader(new StringReader(value));){
            st = reader.read();
        }
        if (!(st instanceof JsonObject)) {
            throw new IOException("Found invalid data structure while parsing PasswordPrincipal");
        }
        JsonObject obj = (JsonObject)st;
        JsonString str = obj.getJsonString(PASSWORD_FIELD);
        if (str != null) {
            if (!Strings.isNullOrEmpty((String)str.getString())) {
                try {
                    return new PasswordPrincipal(this.sealer.unwrap(str.getString()));
                }
                catch (DataSealerException e) {
                    throw new IOException(e);
                }
            }
            this.log.warn("Skipping null/empty PasswordPrincipal");
        }
        return null;
    }

    @Nonnull
    private synchronized JsonObjectBuilder getJsonObjectBuilder() {
        return this.objectBuilderFactory.createObjectBuilder();
    }

    @Nonnull
    private synchronized JsonArrayBuilder getJsonArrayBuilder() {
        return this.objectBuilderFactory.createArrayBuilder();
    }
}

