/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.spnego.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.spnego.impl.KerberosRealmSettings;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public class KerberosSettings
extends AbstractInitializableComponent {
    @Nonnull
    @NotEmpty
    private String loginModuleClassName = "com.sun.security.auth.module.Krb5LoginModule";
    private boolean refreshKrb5Config;
    @NonnullAfterInit
    @NonnullElements
    private Collection<KerberosRealmSettings> realmSettings = Collections.emptyList();

    public void setLoginModuleClassName(@Nonnull @NotEmpty String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.loginModuleClassName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Class name cannot be null or empty");
    }

    @Nonnull
    @NotEmpty
    public String getLoginModuleClassName() {
        return this.loginModuleClassName;
    }

    public void setRefreshKrb5Config(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.refreshKrb5Config = flag;
    }

    public boolean getRefreshKrb5Config() {
        return this.refreshKrb5Config;
    }

    public void setRealms(@Nonnull @NonnullElements Collection<KerberosRealmSettings> realms) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(realms, (String)"The realms collection cannot be null");
        this.realmSettings = new ArrayList<KerberosRealmSettings>(Collections2.filter(realms, (Predicate)Predicates.notNull()));
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Collection<KerberosRealmSettings> getRealms() {
        return this.realmSettings;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.realmSettings.isEmpty()) {
            throw new ComponentInitializationException("Realm collection cannot be empty");
        }
    }
}

