/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.audit.impl;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.joda.time.DateTime;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml2.core.ArtifactResponse;

public class AssertionInstantAuditExtractor
implements Function<ProfileRequestContext, Collection<DateTime>> {
    @Nonnull
    private final Function<ProfileRequestContext, SAMLObject> responseLookupStrategy;

    public AssertionInstantAuditExtractor(@Nonnull Function<ProfileRequestContext, SAMLObject> strategy) {
        this.responseLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Response lookup strategy cannot be null");
    }

    @Nullable
    public Collection<DateTime> apply(@Nullable ProfileRequestContext input) {
        SAMLObject message = (SAMLObject)this.responseLookupStrategy.apply((Object)input);
        if (message != null) {
            if (message instanceof ArtifactResponse) {
                message = ((ArtifactResponse)message).getMessage();
            }
            if (message instanceof org.opensaml.saml.saml2.core.Response) {
                List assertions = ((org.opensaml.saml.saml2.core.Response)message).getAssertions();
                if (!assertions.isEmpty()) {
                    return Collections2.transform((Collection)assertions, (Function)new Function<org.opensaml.saml.saml2.core.Assertion, DateTime>(){

                        public DateTime apply(org.opensaml.saml.saml2.core.Assertion input) {
                            return input.getIssueInstant();
                        }
                    });
                }
            } else if (message instanceof Response) {
                List assertions = ((Response)message).getAssertions();
                if (!assertions.isEmpty()) {
                    return Collections2.transform((Collection)assertions, (Function)new Function<Assertion, DateTime>(){

                        public DateTime apply(Assertion input) {
                            return input.getIssueInstant();
                        }
                    });
                }
            } else {
                if (message instanceof org.opensaml.saml.saml2.core.Assertion) {
                    return Collections.singletonList(((org.opensaml.saml.saml2.core.Assertion)message).getIssueInstant());
                }
                if (message instanceof Assertion) {
                    return Collections.singletonList(((Assertion)message).getIssueInstant());
                }
            }
        }
        return Collections.emptyList();
    }
}

