/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import javax.annotation.Nonnull;
import net.shibboleth.idp.saml.nameid.impl.TransientIdGenerationStrategy;
import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import org.opensaml.saml.common.SAMLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoTransientIdGenerationStrategy
extends AbstractIdentifiableInitializableComponent
implements TransientIdGenerationStrategy {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(CryptoTransientIdGenerationStrategy.class);
    @NonnullAfterInit
    private DataSealer dataSealer;
    @Duration
    @Positive
    private long idLifetime = 14400000L;

    public void setDataSealer(@Nonnull DataSealer sealer) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.dataSealer = (DataSealer)Constraint.isNotNull((Object)sealer, (String)"DataSealer cannot be null");
    }

    @Positive
    public long getIdLifetime() {
        return this.idLifetime;
    }

    public void setIdLifetime(@Duration @Positive long lifetime) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.idLifetime = Constraint.isGreaterThan((long)0L, (long)lifetime, (String)"ID lifetime must be positive");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.dataSealer) {
            throw new ComponentInitializationException("DataSealer cannot be null");
        }
    }

    @Override
    @Nonnull
    @NotEmpty
    public String generate(@Nonnull @NotEmpty String relyingPartyId, @Nonnull @NotEmpty String principalName) throws SAMLException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        StringBuilder principalTokenIdBuilder = new StringBuilder();
        principalTokenIdBuilder.append(relyingPartyId).append("!").append(principalName);
        try {
            return this.dataSealer.wrap(principalTokenIdBuilder.toString(), System.currentTimeMillis() + this.idLifetime);
        }
        catch (DataSealerException e) {
            throw new SAMLException("Exception wrapping principal identifier", (Exception)((Object)e));
        }
    }
}

