/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import net.shibboleth.idp.saml.nameid.PersistentIdEntry;
import net.shibboleth.idp.saml.nameid.PersistentIdStore;
import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.annotation.constraint.Live;
import net.shibboleth.utilities.java.support.annotation.constraint.NonNegative;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCPersistentIdStore
extends AbstractInitializableComponent
implements PersistentIdStore {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(JDBCPersistentIdStore.class);
    @NonnullAfterInit
    private DataSource dataSource;
    @Duration
    @NonNegative
    private long queryTimeout;
    @Nonnull
    @NotEmpty
    private String tableName = "shibpid";
    @Nonnull
    @NotEmpty
    private String issuerColumn = "localEntity";
    @Nonnull
    @NotEmpty
    private String recipientColumn = "peerEntity";
    @Nonnull
    @NotEmpty
    private String principalNameColumn = "principalName";
    @Nonnull
    @NotEmpty
    private String sourceIdColumn = "localId";
    @Nonnull
    @NotEmpty
    private String persistentIdColumn = "persistentId";
    @Nonnull
    @NotEmpty
    private String peerProvidedIdColumn = "peerProvidedId";
    @Nonnull
    @NotEmpty
    private String creationTimeColumn = "creationDate";
    @Nonnull
    @NotEmpty
    private String deactivationTimeColumn = "deactivationDate";
    @NonnullAfterInit
    private String idEntrySelectSQL;
    @NonnullAfterInit
    private String deactivateSQL;

    @Nonnull
    @NotEmpty
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(@Nonnull @NotEmpty String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.tableName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Table name cannot be null or empty");
    }

    @Nonnull
    @NotEmpty
    public String getLocalEntityColumn() {
        return this.issuerColumn;
    }

    public void setLocalEntityColumn(@Nonnull @NotEmpty String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.issuerColumn = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Column name cannot be null or empty");
    }

    @Nonnull
    @NotEmpty
    public String getPeerEntityColumn() {
        return this.recipientColumn;
    }

    public void setPeerEntityColumn(@Nonnull @NotEmpty String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.recipientColumn = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Column name cannot be null or empty");
    }

    @Nonnull
    @NotEmpty
    public String getPrincipalNameColumn() {
        return this.principalNameColumn;
    }

    public void setPrincipalNameColumn(@Nonnull @NotEmpty String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.principalNameColumn = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Column name cannot be null or empty");
    }

    @Nonnull
    @NotEmpty
    public String getSourceIdColumn() {
        return this.sourceIdColumn;
    }

    public void setSourceIdColumn(@Nonnull @NotEmpty String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.sourceIdColumn = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Column name cannot be null or empty");
    }

    @Nonnull
    @NotEmpty
    public String getPersistentIdColumn() {
        return this.persistentIdColumn;
    }

    public void setPersistentIdColumn(@Nonnull @NotEmpty String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.persistentIdColumn = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Column name cannot be null or empty");
    }

    @Nonnull
    @NotEmpty
    public String getPeerProvidedIdColumn() {
        return this.peerProvidedIdColumn;
    }

    public void setPeerProvidedIdColumn(@Nonnull @NotEmpty String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.peerProvidedIdColumn = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Column name cannot be null or empty");
    }

    @Nonnull
    @NotEmpty
    public String getCreateTimeColumn() {
        return this.creationTimeColumn;
    }

    public void setCreateTimeColumn(@Nonnull @NotEmpty String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.creationTimeColumn = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Column name cannot be null or empty");
    }

    @Nonnull
    @NotEmpty
    public String getDeactivationTimeColumn() {
        return this.deactivationTimeColumn;
    }

    public void setDeactivationTimeColumn(@Nonnull @NotEmpty String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.deactivationTimeColumn = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Column name cannot be null or empty");
    }

    @NonnullAfterInit
    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(@Nonnull DataSource source) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.dataSource = (DataSource)Constraint.isNotNull((Object)source, (String)"DataSource cannot be null");
    }

    @NonNegative
    public long getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(@Duration @NonNegative long timeout) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.queryTimeout = Constraint.isGreaterThanOrEqual((long)0L, (long)timeout, (String)"Timeout must be greater than or equal to 0");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.dataSource) {
            throw new ComponentInitializationException(this.getLogPrefix() + " No database connection provided");
        }
        this.idEntrySelectSQL = "SELECT * FROM " + this.tableName + " WHERE ";
        this.deactivateSQL = "UPDATE " + this.tableName + " SET " + this.deactivationTimeColumn + "= ? WHERE " + this.persistentIdColumn + "= ?";
    }

    public boolean isAvailable(@Nonnull @NotEmpty String persistentId) throws IOException {
        return this.getPersistentIdEntry(persistentId, false) == null;
    }

    public void store(@Nonnull PersistentIdEntry entry) throws IOException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        try {
            this.validatePersistentIdEntry(entry);
        }
        catch (SQLException e2) {
            throw new IOException(e2);
        }
        String sql = this.getInsertSql();
        try (Connection dbConn = this.dataSource.getConnection();){
            this.log.debug("{} Storing persistent ID entry based on prepared sql statement: {}", (Object)this.getLogPrefix(), (Object)sql);
            PreparedStatement statement = dbConn.prepareStatement(sql);
            statement.setQueryTimeout((int)(this.queryTimeout / 1000L));
            this.log.debug("{} Setting prepared statement parameter {}: {}", new Object[]{this.getLogPrefix(), 1, entry.getIssuerEntityId()});
            statement.setString(1, entry.getIssuerEntityId());
            this.log.debug("{} Setting prepared statement parameter {}: {}", new Object[]{this.getLogPrefix(), 2, entry.getRecipientEntityId()});
            statement.setString(2, entry.getRecipientEntityId());
            this.log.debug("{} Setting prepared statement parameter {}: {}", new Object[]{this.getLogPrefix(), 3, entry.getPrincipalName()});
            statement.setString(3, entry.getPrincipalName());
            this.log.debug("{} Setting prepared statement parameter {}: {}", new Object[]{this.getLogPrefix(), 4, entry.getSourceId()});
            statement.setString(4, entry.getSourceId());
            this.log.debug("{} Setting prepared statement parameter {}: {}", new Object[]{this.getLogPrefix(), 5, entry.getPersistentId()});
            statement.setString(5, entry.getPersistentId());
            if (entry.getPeerProvidedId() == null) {
                this.log.debug("{} Setting prepared statement parameter {}: {}", new Object[]{this.getLogPrefix(), 6, 12});
                statement.setNull(6, 12);
            } else {
                this.log.debug("{} Setting prepared statement parameter {}: {}", new Object[]{this.getLogPrefix(), 6, entry.getPeerProvidedId()});
                statement.setString(6, entry.getPeerProvidedId());
            }
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            this.log.debug("{} Setting prepared statement parameter {}: {}", new Object[]{this.getLogPrefix(), 7, timestamp.toString()});
            statement.setTimestamp(7, timestamp);
            this.log.debug(statement.toString());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getCount(@Nonnull @NotEmpty String issuer, @Nonnull @NotEmpty String recipient, @Nonnull @NotEmpty String sourceId) throws IOException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT");
        sqlBuilder.append(" count(").append(this.persistentIdColumn).append(")");
        sqlBuilder.append(" FROM ").append(this.tableName).append(" WHERE ");
        sqlBuilder.append(this.issuerColumn).append(" = ?");
        sqlBuilder.append(" AND ");
        sqlBuilder.append(this.recipientColumn).append(" = ?");
        sqlBuilder.append(" AND ");
        sqlBuilder.append(this.sourceIdColumn).append(" = ?");
        String sql = sqlBuilder.toString();
        try (Connection dbConn = this.dataSource.getConnection();){
            this.log.debug("{} Selecting number of persistent ID entries based on prepared sql statement: {}", (Object)this.getLogPrefix(), (Object)sql);
            PreparedStatement statement = dbConn.prepareStatement(sql);
            statement.setQueryTimeout((int)(this.queryTimeout / 1000L));
            this.log.debug("{} Setting prepared statement parameter {}: {}", new Object[]{this.getLogPrefix(), 1, issuer});
            statement.setString(1, issuer);
            this.log.debug("{} Setting prepared statement parameter {}: {}", new Object[]{this.getLogPrefix(), 2, recipient});
            statement.setString(2, recipient);
            this.log.debug("{} Setting prepared statement parameter {}: {}", new Object[]{this.getLogPrefix(), 3, sourceId});
            statement.setString(3, sourceId);
            ResultSet rs = statement.executeQuery();
            rs.next();
            int n = rs.getInt(1);
            return n;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Nullable
    public PersistentIdEntry getActiveEntry(@Nonnull @NotEmpty String persistentId) throws IOException {
        return this.getPersistentIdEntry(persistentId, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public PersistentIdEntry getActiveEntry(@Nonnull @NotEmpty String issuer, @Nonnull @NotEmpty String recipient, @Nonnull @NotEmpty String sourceId) throws IOException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        StringBuilder sqlBuilder = new StringBuilder(this.idEntrySelectSQL);
        sqlBuilder.append(this.issuerColumn).append(" = ?");
        sqlBuilder.append(" AND ").append(this.recipientColumn).append(" = ?");
        sqlBuilder.append(" AND ").append(this.sourceIdColumn).append(" = ?");
        sqlBuilder.append(" AND ").append(this.deactivationTimeColumn).append(" IS NULL");
        String sql = sqlBuilder.toString();
        this.log.debug("{} Selecting active persistent ID entry based on prepared sql statement: {}", (Object)this.getLogPrefix(), (Object)sql);
        try (Connection dbConn = this.dataSource.getConnection();){
            PreparedStatement statement = dbConn.prepareStatement(sql);
            statement.setQueryTimeout((int)(this.queryTimeout / 1000L));
            this.log.debug("{} Setting prepared statement parameter {}: {}", new Object[]{this.getLogPrefix(), 1, issuer});
            statement.setString(1, issuer);
            this.log.debug("{} Setting prepared statement parameter {}: {}", new Object[]{this.getLogPrefix(), 2, recipient});
            statement.setString(2, recipient);
            this.log.debug("{} Setting prepared statement parameter {}: {}", new Object[]{this.getLogPrefix(), 3, sourceId});
            statement.setString(3, sourceId);
            this.log.debug("{} Getting active persistent Id entries.", (Object)this.getLogPrefix());
            List<PersistentIdEntry> entries = this.buildIdentifierEntries(statement.executeQuery());
            if (entries == null || entries.size() == 0) {
                PersistentIdEntry persistentIdEntry = null;
                return persistentIdEntry;
            }
            if (entries.size() > 1) {
                this.log.warn("{} More than one active identifier, only the first will be used", (Object)this.getLogPrefix());
            }
            PersistentIdEntry persistentIdEntry = entries.get(0);
            return persistentIdEntry;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    public void deactivate(@Nonnull @NotEmpty String persistentId, @Nullable DateTime deactivation) throws IOException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        Timestamp deactivationTime = deactivation == null ? new Timestamp(System.currentTimeMillis()) : new Timestamp(deactivation.getMillis());
        try (Connection dbConn = this.dataSource.getConnection();){
            this.log.debug("Deactivating persistent id {} as of {}", (Object)persistentId, (Object)deactivationTime.toString());
            PreparedStatement statement = dbConn.prepareStatement(this.deactivateSQL);
            statement.setQueryTimeout((int)(this.queryTimeout / 1000L));
            statement.setTimestamp(1, deactivationTime);
            statement.setString(2, persistentId);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private PersistentIdEntry getPersistentIdEntry(@Nonnull @NotEmpty String persistentId, boolean onlyActiveId) throws IOException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        StringBuilder sqlBuilder = new StringBuilder(this.idEntrySelectSQL);
        sqlBuilder.append(this.persistentIdColumn).append(" = ?");
        if (onlyActiveId) {
            sqlBuilder.append(" AND ").append(this.deactivationTimeColumn).append(" IS NULL");
        }
        String sql = sqlBuilder.toString();
        this.log.debug("{} Selecting persistent ID entry based on prepared sql statement: {}", (Object)this.getLogPrefix(), (Object)sql);
        try (Connection dbConn = this.dataSource.getConnection();){
            PreparedStatement statement = dbConn.prepareStatement(sql);
            statement.setQueryTimeout((int)(this.queryTimeout / 1000L));
            this.log.debug("{} Setting prepared statement parameter {}: {}", new Object[]{this.getLogPrefix(), 1, persistentId});
            statement.setString(1, persistentId);
            List<PersistentIdEntry> entries = this.buildIdentifierEntries(statement.executeQuery());
            if (entries == null || entries.size() == 0) {
                PersistentIdEntry persistentIdEntry = null;
                return persistentIdEntry;
            }
            if (entries.size() > 1) {
                this.log.warn("{} More than one identifier found, only the first will be used", (Object)this.getLogPrefix());
            }
            PersistentIdEntry persistentIdEntry = entries.get(0);
            return persistentIdEntry;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    protected void validatePersistentIdEntry(@Nonnull PersistentIdEntry entry) throws SQLException {
        boolean doThrow = false;
        if (null == entry.getIssuerEntityId()) {
            this.log.warn("{} Entry {} has null issuer id", (Object)this.getLogPrefix(), (Object)entry);
            doThrow = true;
        }
        if (null == entry.getRecipientEntityId()) {
            this.log.warn("{} Entry {} has null recipient id", (Object)this.getLogPrefix(), (Object)entry);
            doThrow = true;
        }
        if (null == entry.getPrincipalName()) {
            this.log.warn("{} Entry {} has null principal name", (Object)this.getLogPrefix(), (Object)entry);
            doThrow = true;
        }
        if (null == entry.getSourceId()) {
            this.log.warn("{} Entry {} has null source id", (Object)this.getLogPrefix(), (Object)entry);
            doThrow = true;
        }
        if (null == entry.getPersistentId()) {
            this.log.warn("{} Entry {} has null persistent id", (Object)this.getLogPrefix(), (Object)entry);
            doThrow = true;
        }
        if (doThrow) {
            throw new SQLException("Entry is not consistent with database constraints");
        }
    }

    @Nonnull
    @NotEmpty
    private String getInsertSql() {
        StringBuilder sqlBuilder = new StringBuilder("INSERT INTO ");
        sqlBuilder.append(this.tableName).append(" (");
        sqlBuilder.append(this.issuerColumn).append(", ");
        sqlBuilder.append(this.recipientColumn).append(", ");
        sqlBuilder.append(this.principalNameColumn).append(", ");
        sqlBuilder.append(this.sourceIdColumn).append(", ");
        sqlBuilder.append(this.persistentIdColumn).append(", ");
        sqlBuilder.append(this.peerProvidedIdColumn).append(", ");
        sqlBuilder.append(this.creationTimeColumn);
        sqlBuilder.append(") VALUES (?, ?, ?, ?, ?, ?, ?)");
        return sqlBuilder.toString();
    }

    @Nonnull
    @NonnullElements
    @Live
    private List<PersistentIdEntry> buildIdentifierEntries(@Nonnull ResultSet resultSet) throws SQLException {
        ArrayList<PersistentIdEntry> entries = new ArrayList<PersistentIdEntry>();
        while (resultSet.next()) {
            PersistentIdEntry entry = new PersistentIdEntry();
            entry.setIssuerEntityId(resultSet.getString(this.issuerColumn));
            entry.setRecipientEntityId(resultSet.getString(this.recipientColumn));
            entry.setPrincipalName(resultSet.getString(this.principalNameColumn));
            entry.setPersistentId(resultSet.getString(this.persistentIdColumn));
            entry.setSourceId(resultSet.getString(this.sourceIdColumn));
            entry.setPeerProvidedId(resultSet.getString(this.peerProvidedIdColumn));
            entry.setCreationTime(resultSet.getTimestamp(this.creationTimeColumn));
            entry.setDeactivationTime(resultSet.getTimestamp(this.deactivationTimeColumn));
            entries.add(entry);
            this.log.trace("{} Entry {} added to results", (Object)this.getLogPrefix(), (Object)entry.toString());
        }
        return entries;
    }

    @Nonnull
    @NotEmpty
    private String getLogPrefix() {
        return "Stored Id Store:";
    }
}

