/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.delegation.impl;

import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.utilities.java.support.annotation.Prototype;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Prototype
public class FinalizeSAMLTokenProcessing
extends AbstractProfileAction {
    private Logger log = LoggerFactory.getLogger(FinalizeSAMLTokenProcessing.class);
    private String principalName;

    protected boolean doPreExecute(ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        SubjectCanonicalizationContext c14nContext = (SubjectCanonicalizationContext)profileRequestContext.getSubcontext(SubjectCanonicalizationContext.class);
        if (c14nContext == null) {
            this.log.warn("{} SubjectCanonicalizationContext was missing", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubjectCanonicalizationContext");
            return false;
        }
        this.principalName = c14nContext.getPrincipalName();
        if (this.principalName == null) {
            this.log.warn("{} SubjectCanonicalizationContext principal name was null", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubjectCanonicalizationContext");
            return false;
        }
        this.log.debug("{} Subject c14n from inbound delegated Assertion token produced principal name: {}", (Object)this.principalName, (Object)this.getLogPrefix());
        return true;
    }

    protected void doExecute(ProfileRequestContext profileRequestContext) {
        profileRequestContext.removeSubcontext(SubjectCanonicalizationContext.class);
        SubjectContext subjectContext = (SubjectContext)profileRequestContext.getSubcontext(SubjectContext.class, true);
        subjectContext.setPrincipalName(this.principalName);
    }
}

