/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicates;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.saml.session.SAML2SPSession;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.idp.session.SessionException;
import net.shibboleth.idp.session.SessionManager;
import net.shibboleth.idp.session.SessionResolver;
import net.shibboleth.idp.session.context.LogoutContext;
import net.shibboleth.idp.session.context.SessionContext;
import net.shibboleth.idp.session.criterion.SPSessionCriterion;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.MessageLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.saml.ext.saml2aslo.Asynchronous;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.SessionIndex;
import org.opensaml.saml.saml2.profile.SAML2ObjectSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessLogoutRequest
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ProcessLogoutRequest.class);
    @NonnullAfterInit
    private SessionResolver sessionResolver;
    @NonnullAfterInit
    private SessionManager sessionManager;
    @Nonnull
    private Function<ProfileRequestContext, SubjectContext> subjectContextCreationStrategy = new ChildContextLookup(SubjectContext.class, true);
    @Nonnull
    private Function<ProfileRequestContext, SessionContext> sessionContextCreationStrategy = new ChildContextLookup(SessionContext.class, true);
    @Nonnull
    private Function<ProfileRequestContext, LogoutContext> logoutContextCreationStrategy = new ChildContextLookup(LogoutContext.class, true);
    @Nonnull
    private Function<ProfileRequestContext, CriteriaSet> sessionResolverCriteriaStrategy = new Function<ProfileRequestContext, CriteriaSet>(){

        public CriteriaSet apply(ProfileRequestContext input) {
            if (ProcessLogoutRequest.this.logoutRequest != null && ProcessLogoutRequest.this.logoutRequest.getIssuer() != null && ProcessLogoutRequest.this.logoutRequest.getNameID() != null) {
                return new CriteriaSet(new Criterion[]{new SPSessionCriterion(ProcessLogoutRequest.this.logoutRequest.getIssuer().getValue(), ProcessLogoutRequest.this.logoutRequest.getNameID().getValue())});
            }
            return new CriteriaSet();
        }
    };
    @Nonnull
    private Function<ProfileRequestContext, LogoutRequest> logoutRequestLookupStrategy = Functions.compose((Function)new MessageLookup(LogoutRequest.class), (Function)new InboundMessageContextLookup());
    @Nullable
    private LogoutRequest logoutRequest;

    public void setSessionResolver(@Nonnull SessionResolver resolver) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.sessionResolver = (SessionResolver)Constraint.isNotNull((Object)resolver, (String)"SessionResolver cannot be null");
    }

    public void setSessionManager(@Nonnull SessionManager manager) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.sessionManager = (SessionManager)Constraint.isNotNull((Object)manager, (String)"SessionManager cannot be null");
    }

    public void setSubjectContextCreationStrategy(@Nonnull Function<ProfileRequestContext, SubjectContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.subjectContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"SubjectContext creation strategy cannot be null");
    }

    public void setSessionContextCreationStrategy(@Nonnull Function<ProfileRequestContext, SessionContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.sessionContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"SessionContext creation strategy cannot be null");
    }

    public void setLogoutContextCreationStrategy(@Nonnull Function<ProfileRequestContext, LogoutContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.logoutContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"LogoutContext creation strategy cannot be null");
    }

    public void setSessionResolverCriteriaStrategy(@Nonnull Function<ProfileRequestContext, CriteriaSet> strategy) {
        this.sessionResolverCriteriaStrategy = (Function)Constraint.isNotNull(strategy, (String)"SessionResolver CriteriaSet strategy cannot be null");
    }

    public void setLogoutRequestLookupStrategy(@Nonnull Function<ProfileRequestContext, LogoutRequest> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.logoutRequestLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"LogoutRequest lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (!this.getActivationCondition().equals((Object)Predicates.alwaysFalse())) {
            if (this.sessionResolver == null) {
                throw new ComponentInitializationException("SessionResolver cannot be null");
            }
            if (this.sessionManager == null) {
                throw new ComponentInitializationException("SessionManager cannot be null");
            }
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.logoutRequest = (LogoutRequest)this.logoutRequestLookupStrategy.apply((Object)profileRequestContext);
        if (this.logoutRequest == null) {
            this.log.warn("{} No LogoutRequest found to process", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        if (this.log.isDebugEnabled() && this.logoutRequest.getExtensions() != null && !this.logoutRequest.getExtensions().getUnknownXMLObjects(Asynchronous.DEFAULT_ELEMENT_NAME).isEmpty()) {
            this.log.debug("{} LogoutRequest contained Asynchronous extension", (Object)this.getLogPrefix());
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        try {
            Iterable sessions = this.sessionResolver.resolve(this.sessionResolverCriteriaStrategy.apply((Object)profileRequestContext));
            Iterator sessionIterator = sessions.iterator();
            IdPSession single = null;
            LogoutContext logoutCtx = null;
            int count = 1;
            while (sessionIterator.hasNext()) {
                IdPSession session = (IdPSession)sessionIterator.next();
                if (!this.sessionMatches(session)) {
                    this.log.debug("{} IdP session {} does not contain a matching SP session", (Object)this.getLogPrefix(), (Object)session.getId());
                    continue;
                }
                this.log.debug("{} LogoutRequest matches IdP session {}", (Object)this.getLogPrefix(), (Object)session.getId());
                if (logoutCtx == null) {
                    logoutCtx = (LogoutContext)this.logoutContextCreationStrategy.apply((Object)profileRequestContext);
                    if (logoutCtx == null) {
                        this.log.error("{} Unable to create or locate LogoutContext", (Object)this.getLogPrefix());
                        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
                        return;
                    }
                    SubjectContext subjectCtx = (SubjectContext)this.subjectContextCreationStrategy.apply((Object)profileRequestContext);
                    if (subjectCtx != null) {
                        subjectCtx.setPrincipalName(session.getPrincipalName());
                    }
                    single = session;
                } else {
                    single = null;
                }
                for (SPSession spSession : session.getSPSessions()) {
                    if (this.sessionMatches(spSession)) continue;
                    logoutCtx.getSessionMap().put((Object)spSession.getId(), (Object)spSession);
                    logoutCtx.getKeyedSessionMap().put(Integer.toString(count++), spSession);
                }
                try {
                    this.sessionManager.destroySession(session.getId(), true);
                }
                catch (SessionException e) {
                    this.log.error("{} Error destroying session {}", new Object[]{this.getLogPrefix(), session.getId(), e});
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
                    return;
                }
            }
            if (single != null) {
                SessionContext sessionCtx = (SessionContext)this.sessionContextCreationStrategy.apply((Object)profileRequestContext);
                if (sessionCtx != null) {
                    sessionCtx.setIdPSession(single);
                }
            } else if (logoutCtx == null) {
                this.log.info("{} No active session(s) found matching LogoutRequest", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"SessionNotFound");
            }
        }
        catch (ResolverException e) {
            this.log.error("{} Error resolving matching session(s)", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"SessionNotFound");
        }
    }

    private boolean sessionMatches(@Nonnull IdPSession session) {
        for (SPSession spSession : session.getSPSessions()) {
            if (!this.sessionMatches(spSession)) continue;
            return true;
        }
        return false;
    }

    private boolean sessionMatches(@Nonnull SPSession session) {
        if (session instanceof SAML2SPSession) {
            SAML2SPSession saml2Session = (SAML2SPSession)session;
            if (!saml2Session.getId().equals(this.logoutRequest.getIssuer().getValue())) {
                return false;
            }
            if (!SAML2ObjectSupport.areNameIDsEquivalent((NameID)this.logoutRequest.getNameID(), (NameID)saml2Session.getNameID())) {
                return false;
            }
            if (this.logoutRequest.getSessionIndexes().isEmpty()) {
                return true;
            }
            for (SessionIndex index : this.logoutRequest.getSessionIndexes()) {
                if (index.getSessionIndex() == null || !index.getSessionIndex().equals(saml2Session.getSessionIndex())) continue;
                return true;
            }
        }
        return false;
    }
}

