/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.idp.saml.authn.principal.AuthnContextClassRefPrincipal;
import net.shibboleth.idp.saml.authn.principal.AuthnContextDeclRefPrincipal;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.MessageLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml.saml2.core.AuthnContextDeclRef;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessRequestedAuthnContext
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ProcessRequestedAuthnContext.class);
    @Nonnull
    private Function<ProfileRequestContext, AuthnRequest> authnRequestLookupStrategy = Functions.compose((Function)new MessageLookup(AuthnRequest.class), (Function)new InboundMessageContextLookup());
    @Nonnull
    @NonnullElements
    private Set<String> ignoredContexts = Collections.singleton("urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified");
    @Nullable
    private AuthnRequest authnRequest;

    public void setAuthnRequestLookupStrategy(@Nonnull Function<ProfileRequestContext, AuthnRequest> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.authnRequestLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AuthnRequest lookup strategy cannot be null");
    }

    public void setIgnoredContexts(@Nonnull @NonnullElements Collection<String> contexts) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Collection trimmed = StringSupport.normalizeStringCollection(contexts);
        if (trimmed.isEmpty()) {
            this.ignoredContexts = Collections.emptySet();
        } else {
            this.ignoredContexts = new HashSet<String>(trimmed.size());
            this.ignoredContexts.addAll(trimmed);
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        this.authnRequest = (AuthnRequest)this.authnRequestLookupStrategy.apply((Object)profileRequestContext);
        if (this.authnRequest == null) {
            this.log.debug("{} AuthnRequest message was not returned by lookup strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        return super.doPreExecute(profileRequestContext, authenticationContext);
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        RequestedAuthnContext requestedCtx = this.authnRequest.getRequestedAuthnContext();
        if (requestedCtx == null) {
            this.log.debug("{} AuthnRequest did not contain a RequestedAuthnContext, nothing to do", (Object)this.getLogPrefix());
            return;
        }
        ArrayList<Object> principals = new ArrayList<Object>();
        if (!requestedCtx.getAuthnContextClassRefs().isEmpty()) {
            for (AuthnContextClassRef ref : requestedCtx.getAuthnContextClassRefs()) {
                if (ref.getAuthnContextClassRef() == null) continue;
                if (!this.ignoredContexts.contains(ref.getAuthnContextClassRef())) {
                    principals.add(new AuthnContextClassRefPrincipal(ref.getAuthnContextClassRef()));
                    continue;
                }
                this.log.info("{} Ignoring AuthnContextClassRef: {}", (Object)this.getLogPrefix(), (Object)ref.getAuthnContextClassRef());
            }
        } else if (!requestedCtx.getAuthnContextDeclRefs().isEmpty()) {
            for (AuthnContextDeclRef ref : requestedCtx.getAuthnContextDeclRefs()) {
                if (ref.getAuthnContextDeclRef() == null) continue;
                if (!this.ignoredContexts.contains(ref.getAuthnContextDeclRef())) {
                    principals.add(new AuthnContextDeclRefPrincipal(ref.getAuthnContextDeclRef()));
                    continue;
                }
                this.log.info("{} Ignoring AuthnContextDeclRef: {}", (Object)this.getLogPrefix(), (Object)ref.getAuthnContextDeclRef());
            }
        }
        if (principals.isEmpty()) {
            this.log.debug("{} RequestedAuthnContext did not contain any requested contexts, nothing to do", (Object)this.getLogPrefix());
            return;
        }
        RequestedPrincipalContext rpCtx = new RequestedPrincipalContext();
        if (requestedCtx.getComparison() != null) {
            rpCtx.setOperator(requestedCtx.getComparison().toString());
        } else {
            rpCtx.setOperator(AuthnContextComparisonTypeEnumeration.EXACT.toString());
        }
        rpCtx.setRequestedPrincipals(principals);
        authenticationContext.addSubcontext((BaseContext)rpCtx, true);
        this.log.debug("{} RequestedPrincipalContext created with operator {} and {} custom principal(s)", new Object[]{this.getLogPrefix(), rpCtx.getOperator(), principals.size()});
    }
}

